/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.util;

import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.eclipse.reddeer.junit.util.ReflectionUtil;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionUtilTest {
    @Test
    public void testGettingSimpleValue() {
        A a = new A();
        a.setName("aaa");
        Assert.assertEquals((Object)"aaa", (Object)ReflectionUtil.getValue((Object)a, (String)"name"));
    }

    @Test
    public void testGettingInheritedValue() {
        B b = new B();
        b.setName("bbb");
        Assert.assertEquals((Object)"bbb", (Object)ReflectionUtil.getValue((Object)b, (String)"name"));
    }

    @Test
    public void testGettingComplexValue() {
        A a = new A();
        a.setName("aaa");
        B b = new B();
        b.setName("bbb");
        b.setA(a);
        Assert.assertEquals((Object)"aaa", (Object)ReflectionUtil.getValue((Object)b, (String)"a.name"));
    }

    @Test
    public void testGettingObjectValue() {
        A a = new A();
        a.setName("aaa");
        B b = new B();
        b.setName("bbb");
        b.setA(a);
        Assert.assertEquals((Object)a, (Object)ReflectionUtil.getValue((Object)b, (String)"a"));
    }

    @Test
    public void testGettingNonAttributeValue() {
        A a = new A();
        a.setName("aaa");
        Assert.assertEquals(A.class, (Object)ReflectionUtil.getValue((Object)a, (String)"class"));
    }

    @Test
    public void testGettingNullAttributeValue() {
        A a = new A();
        Assert.assertNull((Object)ReflectionUtil.getValue((Object)a, (String)"name"));
    }

    @Test
    public void testHandlingNonExistingAttributeValue() {
        A a = new A();
        a.setName("aaa");
        try {
            ReflectionUtil.getValue((Object)a, (String)"surname");
        }
        catch (RequirementException e) {
            Assert.assertEquals((Object)("Cannot access surname in " + A.class.getCanonicalName()), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"A requirement exception was expected");
    }

    @Test
    public void testHandlingNPE() {
        B b = new B();
        try {
            ReflectionUtil.getValue((Object)b, (String)"a.name");
        }
        catch (RequirementException e) {
            Assert.assertEquals((Object)"Cannot access a.name since a was resolved as null", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"A requirement exception was expected");
    }

    public static class A {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class B
    extends A {
        private A a;

        public A getA() {
            return this.a;
        }

        public void setA(A a) {
            this.a = a;
        }
    }
}

