/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.DescriptiveStorageLoginDialog;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.DescriptiveStorageNewDialog;
import org.eclipse.reddeer.jface.wizard.WizardDialog;
import org.eclipse.reddeer.swt.impl.button.NoButton;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.group.DefaultGroup;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.hamcrest.Matcher;

public class ChangePasswordWizardDialog
extends WizardDialog {
    private static final int HINTS_COUNT = 2;

    public ChangePasswordWizardDialog() {
        super("Change Password");
    }

    public void ignoreHints() {
        new DefaultShell("Secure Storage - Password Hint Needed");
        new NoButton().click();
    }

    public void fillHints(String questionOne, String questionTwo, String answerOne, String answerTwo) {
        new DefaultShell("Secure Storage - Password Hint Needed");
        new YesButton().click();
        new DefaultShell("Password Recovery");
        this.setFirstHint(questionOne, answerOne);
        this.setSecondHint(questionTwo, answerTwo);
        new OkButton().click();
    }

    public void changeMasterPasswordWithoutHints(String oldPassword, String newPassword) {
        this.changeMasterPassword(oldPassword, newPassword, null, null);
    }

    public void changeMasterPasswordWithHints(String oldPassword, String newPassword, String questionOne, String questionTwo, String answerOne, String answerTwo) {
        this.changeMasterPassword(oldPassword, newPassword, new String[]{questionOne, questionTwo}, new String[]{answerOne, answerTwo});
    }

    private void setFirstHint(String question, String answer) {
        this.setHint(question, answer, "Question 1");
    }

    private void setSecondHint(String question, String answer) {
        this.setHint(question, answer, "Question 2");
    }

    private void setHint(String question, String answer, String groupLabel) {
        DefaultGroup group = new DefaultGroup(groupLabel);
        DefaultText questionField = new DefaultText((ReferencedComposite)group, 0, new Matcher[0]);
        DefaultText answerField = new DefaultText((ReferencedComposite)group, 1, new Matcher[0]);
        questionField.setText(question);
        answerField.setText(answer);
    }

    private void changeMasterPassword(String oldPassword, String newPassword, String[] questions, String[] answers) {
        this.next();
        DescriptiveStorageLoginDialog oldPasswordDialog = new DescriptiveStorageLoginDialog();
        oldPasswordDialog.setPassword(oldPassword);
        oldPasswordDialog.ok();
        this.next();
        DescriptiveStorageNewDialog newPasswordDialog = new DescriptiveStorageNewDialog();
        newPasswordDialog.setNewPassword(newPassword);
        newPasswordDialog.ok();
        if (ChangePasswordWizardDialog.areHintsPresent(questions, answers)) {
            this.fillHints(questions[0], questions[1], answers[0], answers[1]);
        } else {
            this.ignoreHints();
        }
        this.finish();
    }

    private static boolean areHintsPresent(String[] questions, String[] answers) {
        return questions != null && answers != null && questions.length == 2 && answers.length == 2;
    }
}

