/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.requirement.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.requirement.inject.InjectRequirement;
import org.eclipse.reddeer.junit.requirement.inject.RequirementInjectionException;

public class RequirementsInjector {
    public void inject(Object testInstance, Requirements requirements) {
        for (Field field : this.getFields(testInstance.getClass())) {
            if (!field.isAnnotationPresent(InjectRequirement.class) || Modifier.isStatic(field.getModifiers())) continue;
            Requirement<?> requirement = this.loadProperRequirement(field, requirements);
            field.setAccessible(true);
            this.setField(field, testInstance, requirement);
        }
    }

    public void inject(Class<?> testClass, Requirements requirements) {
        for (Field field : this.getFields(testClass)) {
            if (!field.isAnnotationPresent(InjectRequirement.class) || !Modifier.isStatic(field.getModifiers())) continue;
            Requirement<?> requirement = this.loadProperRequirement(field, requirements);
            field.setAccessible(true);
            this.setField(field, null, requirement);
        }
    }

    private List<Field> getFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    private Requirement<?> loadProperRequirement(Field field, Requirements requirements) {
        for (Requirement<?> requirement : requirements) {
            if (!field.getType().equals(requirement.getClass())) continue;
            return requirement;
        }
        throw new RequirementInjectionException("Field type \"" + field.getType() + "\" cannot be injected. " + "No corresponding requirement exists");
    }

    private void setField(Field field, Object testInstance, Requirement<?> requirement) {
        try {
            field.set(testInstance, requirement);
        }
        catch (IllegalArgumentException e) {
            throw new RequirementInjectionException("Cannot set field \"" + field + "\" due to illegal argument issue. " + e.getLocalizedMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RequirementInjectionException("Cannot set field \"" + field + "\" due to illegal access issue. " + e.getLocalizedMessage(), e);
        }
    }
}

