/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.views;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.reddeer.logparser.LogParserActivator;
import org.eclipse.reddeer.logparser.LogParserLog;
import org.eclipse.reddeer.logparser.dialogs.LogParserPropertiesDialog;
import org.eclipse.reddeer.logparser.editors.LogParserEditor;
import org.eclipse.reddeer.logparser.model.LogData;
import org.eclipse.reddeer.logparser.model.LogParserDataModel;
import org.eclipse.reddeer.logparser.preferences.LogParserPreferencesPageModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.ViewPart;

public class LogParserView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "org.eclipse.reddeer.logparser.views.LogParserView";
    private TableViewer logsViewer;
    private Action actionAdd;
    private Action actionModify;
    private Action actionRemove;
    private Action actionParse;
    private static Image LOG_PARSER_ICON;
    private ArrayList<LogData> currentLogs = null;

    public LogParserView() {
        LogParserActivator.addPropertyChangeListener(this);
    }

    public void createPartControl(Composite parent) {
        if (LOG_PARSER_ICON == null) {
            LOG_PARSER_ICON = LogParserActivator.getImageDescriptor("icons/logparser.gif").createImage();
        }
        this.logsViewer = new TableViewer(parent, 772);
        this.logsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.logsViewer.setLabelProvider((IBaseLabelProvider)new LogParserViewLabelProvider());
        this.logsViewer.setSorter((ViewerSorter)new LogLocationSorter());
        this.currentLogs = LogParserDataModel.getLogParserData();
        this.logsViewer.setInput(this.currentLogs);
        this.getSite().setSelectionProvider((ISelectionProvider)this.logsViewer);
        this.makeActions();
        this.enableActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.logsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LogParserView.this.enableActions();
            }
        });
        this.logsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LogParserView.this.actionParse.run();
            }
        });
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LogParserView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.logsViewer.getControl());
        this.logsViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.logsViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionParse);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionModify);
        manager.add((IAction)this.actionRemove);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionParse);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionModify);
        manager.add((IAction)this.actionRemove);
    }

    private void makeActions() {
        this.actionParse = new Action(){

            public void run() {
                LogParserView.this.parseLog();
            }
        };
        this.actionParse.setText("Parse Log");
        this.actionParse.setToolTipText("Parse Log");
        this.actionParse.setImageDescriptor(LogParserActivator.getImageDescriptor("icons/parse.gif"));
        this.actionAdd = new Action(){

            public void run() {
                LogParserView.this.addLog();
            }
        };
        this.actionAdd.setText("Add Log");
        this.actionAdd.setToolTipText("Add Log");
        this.actionAdd.setImageDescriptor(LogParserActivator.getImageDescriptor("icons/addlog.gif"));
        this.actionModify = new Action(){

            public void run() {
                LogParserView.this.modifyLog();
            }
        };
        this.actionModify.setText("Modify Log rules");
        this.actionModify.setToolTipText("Modify parsing rules for Log");
        this.actionModify.setImageDescriptor(LogParserActivator.getImageDescriptor("icons/modifylog.gif"));
        this.actionRemove = new Action(){

            public void run() {
                LogParserView.this.removeLog();
            }
        };
        this.actionRemove.setText("Remove Log");
        this.actionRemove.setToolTipText("Remove Log");
        this.actionRemove.setImageDescriptor(LogParserActivator.getImageDescriptor("icons/removelog.gif"));
    }

    private void enableActions() {
        if (this.logsViewer.getSelection().isEmpty()) {
            this.actionParse.setEnabled(false);
            this.actionModify.setEnabled(false);
            this.actionRemove.setEnabled(false);
        } else {
            this.actionParse.setEnabled(true);
            this.actionModify.setEnabled(true);
            this.actionRemove.setEnabled(true);
        }
    }

    private void addLog() {
        LogParserPropertiesDialog logParserPropertiesDialog = new LogParserPropertiesDialog(this.logsViewer.getControl().getShell(), new LogData(), LogParserPreferencesPageModel.getParseRules(), this.currentLogs);
        if (logParserPropertiesDialog.open() == 0) {
            LogData newLogData = logParserPropertiesDialog.getLogData();
            this.logsViewer.add((Object)newLogData);
            this.currentLogs.add(newLogData);
            this.logsViewer.setSelection((ISelection)new StructuredSelection((Object)newLogData));
        }
        LogParserDataModel.saveLogParserData(this.currentLogs);
    }

    private void modifyLog() {
        LogData updLogData = ((LogData)this.logsViewer.getStructuredSelection().getFirstElement()).clone();
        LogData updModelLogData = this.currentLogs.get(this.currentLogs.indexOf(updLogData));
        LogParserPropertiesDialog logParserPropertiesDialog = new LogParserPropertiesDialog(this.logsViewer.getControl().getShell(), updLogData, LogParserPreferencesPageModel.getParseRules(), this.currentLogs);
        if (logParserPropertiesDialog.open() == 0) {
            LogData.copyFields(logParserPropertiesDialog.getLogData(), updModelLogData);
            this.logsViewer.setInput(this.currentLogs);
            this.logsViewer.setSelection((ISelection)new StructuredSelection((Object)updModelLogData));
        }
        LogParserDataModel.saveLogParserData(this.currentLogs);
    }

    private void removeLog() {
        LogData removeLogData = (LogData)this.logsViewer.getStructuredSelection().getFirstElement();
        this.logsViewer.remove((Object)removeLogData);
        this.currentLogs.remove(removeLogData);
        LogParserDataModel.saveLogParserData(this.currentLogs);
    }

    private void parseLog() {
        LogData logData = (LogData)this.logsViewer.getStructuredSelection().getFirstElement();
        this.openLogParserEditor(logData);
    }

    private void openLogParserEditor(LogData logData) {
        File fileToOpen = new File(logData.getLocation());
        Assert.isNotNull((Object)fileToOpen);
        if (fileToOpen.exists() && fileToOpen.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                int numOpenedEditors = page.getEditorReferences().length;
                IEditorPart editorPart = page.openEditor((IEditorInput)new FileStoreEditorInput(fileStore), "org.eclipse.reddeer.logparser.editors.LogParserEditor");
                LogParserEditor logParserEditor = (LogParserEditor)editorPart;
                if (page.getEditorReferences().length == numOpenedEditors) {
                    logParserEditor.refreshLog();
                }
                logParserEditor.parseLog(logData);
            }
            catch (PartInitException pie) {
                LogParserLog.logError("Unable to open log in editor", pie);
            }
        } else {
            MessageDialog.openError((Shell)this.logsViewer.getControl().getShell(), (String)"Error", (String)("Log file: " + fileToOpen.getAbsolutePath() + " doesn't exist."));
        }
    }

    public void setFocus() {
        this.logsViewer.getControl().setFocus();
    }

    public static void disposeImages() {
        if (LOG_PARSER_ICON != null) {
            LOG_PARSER_ICON.dispose();
            LOG_PARSER_ICON = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        IStructuredSelection logsSelection = this.logsViewer.getStructuredSelection();
        this.currentLogs = LogParserDataModel.getLogParserData();
        this.logsViewer.setInput(this.currentLogs);
        this.logsViewer.setSelection((ISelection)logsSelection);
    }

    class LogLocationSorter
    extends ViewerSorter {
        LogLocationSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return ((LogData)e1).getLocation().compareToIgnoreCase(((LogData)e2).getLocation());
        }
    }

    class LogParserViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        LogParserViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return ((LogData)obj).getLocation();
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return LOG_PARSER_ICON;
        }
    }
}

