/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.text;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.swt.test.utils.LabelTestUtils;
import org.eclipse.reddeer.swt.test.utils.LayoutTestUtils;
import org.eclipse.reddeer.swt.test.utils.TextTestUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LabeledTextTest
extends SWTLayerTestCase {
    private int modifiedCount = 0;

    @Before
    public void setupModifiedCount() {
        this.modifiedCount = 0;
    }

    @Override
    protected void createControls(Shell shell) {
        LabelTestUtils.createLabel((Composite)shell, "Test label");
        LabelTestUtils.createLabel((Composite)shell, "", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        Text swtText = TextTestUtils.createText((Composite)shell, "Test text");
        final Text swtTextStatus = TextTestUtils.createText((Composite)shell, "Status");
        swtText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                swtTextStatus.setText("focusLost");
            }

            public void focusGained(FocusEvent arg0) {
                swtTextStatus.setText("focusGained");
            }
        });
        LabelTestUtils.createLabel((Composite)shell, "Test label1");
        LabelTestUtils.createLabel((Composite)shell, "", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        Text swtText1 = TextTestUtils.createText((Composite)shell, "Test text1");
        swtText1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ++LabeledTextTest.this.modifiedCount;
            }
        });
        LabelTestUtils.createLabel((Composite)shell, "Test label2");
        LabelTestUtils.createLabel((Composite)shell, "", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK"));
        LabelTestUtils.createLabel((Composite)shell, "", PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"));
        Text swtText2 = TextTestUtils.createText((Composite)shell, "Test text2");
        swtText2.setEditable(false);
        LabelTestUtils.createLabel((Composite)shell, "Test label3");
        Text swtText3 = TextTestUtils.createText((Composite)shell, "");
        swtText3.setMessage("message");
        LabelTestUtils.createCLabel((Composite)shell, "Test clabel");
        TextTestUtils.createText((Composite)shell, "Test ctext");
        Composite formContainer = LayoutTestUtils.createFlatFormComposite((Composite)shell);
        Text text1 = TextTestUtils.createText(formContainer, "");
        text1.setText("formtext");
        text1.setLayoutData((Object)LayoutTestUtils.entryLayoutData());
        Label label1 = LabelTestUtils.createLabel(formContainer, "");
        label1.setText("FormLabel");
        label1.setLayoutData((Object)LayoutTestUtils.labelLayoutData((Control)text1));
        Text text2 = TextTestUtils.createText(formContainer, "");
        text2.setText("cformtext");
        text2.setLayoutData((Object)LayoutTestUtils.entryLayoutData((Control)text1));
        CLabel label2 = LabelTestUtils.createCLabel(formContainer, "");
        label2.setText("FormCLabel");
        label2.setLayoutData((Object)LayoutTestUtils.labelLayoutData((Control)text2));
        LabelTestUtils.createLabel((Composite)shell, "Test label4");
        Composite composite = new Composite((Composite)shell, 16384);
        TextTestUtils.createText(composite, "Test text4");
        LabelTestUtils.createLabel((Composite)shell, "Required label1*");
        TextTestUtils.createText((Composite)shell, "Required text1");
        LabelTestUtils.createLabel((Composite)shell, "Required label2 *");
        TextTestUtils.createText((Composite)shell, "Required text2");
        LabelTestUtils.createLabel((Composite)shell, "Special label?");
        TextTestUtils.createText((Composite)shell, "Special text");
    }

    @Test
    public void findLabeledTextWithIcon() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test label").getText().equals("Test text"));
    }

    @Test
    public void findLabeledTextWithTwoIcons() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test label2").getText().equals("Test text2"));
    }

    @Test
    public void findLabeledTextWithFormLabel() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"formtext", (Object)new LabeledText("FormLabel").getText());
    }

    @Test
    public void findLabeledTextWithFormCLabel() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"cformtext", (Object)new LabeledText("FormCLabel").getText());
    }

    @Test
    public void findLabeledTextWithoutIcon() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test label1").getText().equals("Test text1"));
    }

    @Test
    public void findLabeledTextWithCLabel() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test clabel").getText().equals("Test ctext"));
    }

    @Test
    public void findLabeledTextWithOutsideLabel() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test label4").getText().equals("Test text4"));
    }

    @Test
    public void findLabeledTextWithAsterisk() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"Required text1", (Object)new LabeledText("Required label1*").getText());
    }

    @Test
    public void findLabeledTextForRequiredField() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"Required text1", (Object)new LabeledText("Required label1").getText());
    }

    @Test
    public void findLabeledTextWithAsteriskWithSpace() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"Required text2", (Object)new LabeledText("Required label2 *").getText());
    }

    @Test
    public void findLabeledTextForRequiredFieldWithSpace() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"Required text2", (Object)new LabeledText("Required label2").getText());
    }

    @Test
    public void findLabeledTextWithSpecialChar() {
        new DefaultShell("Testing shell");
        Assert.assertEquals((Object)"Special text", (Object)new LabeledText("Special label?").getText());
    }

    @Test
    public void getTextMessage() {
        new DefaultShell("Testing shell");
        Assert.assertTrue((boolean)new LabeledText("Test label3").getMessage().equals("message"));
    }

    @Test
    public void setFocusTest() {
        new DefaultShell("Testing shell");
        DefaultText text = new DefaultText(1, new Matcher[0]);
        new LabeledText("Test label");
        Assert.assertEquals((Object)"focusGained", (Object)text.getText());
        new LabeledText("Test label1");
        Assert.assertEquals((Object)"focusLost", (Object)text.getText());
        new LabeledText("Test label");
        Assert.assertEquals((Object)"focusGained", (Object)text.getText());
    }

    @Test
    public void setTextTest() {
        new DefaultShell("Testing shell");
        new LabeledText("Test label1").setText("funny text");
        Assert.assertEquals((Object)"funny text", (Object)new LabeledText("Test label1").getText());
        Assert.assertEquals((long)1L, (long)this.modifiedCount);
    }

    @Test
    public void typeTextTest() {
        new DefaultShell("Testing shell");
        new LabeledText("Test label1").typeText("not so funny text");
        Assert.assertEquals((Object)"not so funny text", (Object)new LabeledText("Test label1").getText());
        Assert.assertEquals((long)18L, (long)this.modifiedCount);
    }

    @Test(expected=RedDeerException.class)
    public void setNonEditableTextTest() {
        new DefaultShell("Testing shell");
        new LabeledText("Test label2").setText("funny text");
    }
}

