/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.execution;

import java.util.ArrayList;
import java.util.Comparator;
import org.eclipse.reddeer.junit.execution.IExecutionPriority;
import org.eclipse.reddeer.junit.execution.PriorityComparator;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.execution.HighPriority;
import org.eclipse.reddeer.junit.test.execution.LowPriority;
import org.eclipse.reddeer.junit.test.execution.NormalPriority;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class PriorityComparatorTest {
    private PriorityComparator priorityComparator = new PriorityComparator();
    private IExecutionPriority low1 = new LowPriority();
    private IExecutionPriority low2 = new LowPriority();
    private IExecutionPriority normal1 = new NormalPriority();
    private IExecutionPriority normal2 = new NormalPriority();
    private IExecutionPriority high1 = new HighPriority();
    private IExecutionPriority high2 = new HighPriority();

    @Test
    public void testEqualPrioritized() {
        Assert.assertTrue((String)"Objects should have been equals", (this.priorityComparator.compare(this.low1, this.low2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Objects should have been equals", (this.priorityComparator.compare(this.normal1, this.normal2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Objects should have been equals", (this.priorityComparator.compare(this.high1, this.high2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVariousPriority() {
        Assert.assertTrue((String)"Compared prioritized objects order is not correct", (this.priorityComparator.compare(this.normal1, this.low1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Compared prioritized objects order is not correct", (this.priorityComparator.compare(this.high1, this.normal1) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Compared prioritized objects order is not correct", (this.priorityComparator.compare(this.high1, this.low1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testOrderOfSortedList() {
        ArrayList<IExecutionPriority> unsortedList = new ArrayList<IExecutionPriority>();
        unsortedList.add(this.normal1);
        unsortedList.add(this.low1);
        unsortedList.add(this.high1);
        unsortedList.sort((Comparator<IExecutionPriority>)this.priorityComparator);
        Assert.assertTrue((String)"List was not ordered correctly. Order should be from high to low", (((IExecutionPriority)unsortedList.get(0)).equals(this.high1) && ((IExecutionPriority)unsortedList.get(1)).equals(this.normal1) && ((IExecutionPriority)unsortedList.get(2)).equals(this.low1) ? 1 : 0) != 0);
    }
}

