/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.menu;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.impl.menu.ContextMenu;
import org.eclipse.reddeer.swt.impl.menu.ShellMenu;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.test.impl.menu.AbstractMenuTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ShellMenuTest
extends AbstractMenuTest {
    @Test
    public void shellMenuTest() {
        new DefaultShell("MenuShell");
        ShellMenu menu = new ShellMenu();
        Assert.assertTrue((menu.getItems().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ShellMenuBarItem", (Object)((MenuItem)menu.getItems().get(0)).getText());
        menu.getItem(new String[]{"ShellMenuBarItem", "ShellMenuBarItem1"});
    }

    @Test
    public void shellMenuTest1() {
        ShellMenu menu = new ShellMenu((Shell)new DefaultShell("MenuShell"));
        Assert.assertTrue((menu.getItems().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"ShellMenuBarItem", (Object)((MenuItem)menu.getItems().get(0)).getText());
        menu.getItem(new String[]{"ShellMenuBarItem", "ShellMenuBarItem1"});
    }

    @Test
    public void hasExistingMenuItem() {
        DefaultShell shell = new DefaultShell("MenuShell");
        ShellMenu menu = new ShellMenu((Shell)shell);
        Assert.assertTrue((boolean)menu.hasItem(new String[]{"ShellMenuBarItem"}));
    }

    @Test
    public void hasExistingMenuItemWithPath() {
        DefaultShell shell = new DefaultShell("MenuShell");
        ShellMenu menu = new ShellMenu((Shell)shell);
        Assert.assertTrue((boolean)menu.hasItem(new String[]{"ShellMenuBarItem", "ShellMenuBarItem1"}));
    }

    @Test
    public void hasNonExistingMenuItem() {
        DefaultShell shell = new DefaultShell("MenuShell");
        ContextMenu menu = new ContextMenu((Control)shell);
        Assert.assertFalse((boolean)menu.hasItem(new String[]{"ShellMenuBarItemX"}));
    }

    @Test
    public void testErrorMessageForNonexistingMenuItem() {
        DefaultShell shell = new DefaultShell("MenuShell");
        ShellMenu menu = new ShellMenu((Shell)shell);
        String msg = null;
        try {
            menu.getItem(new String[]{"ShellMenuBarItemX"});
        }
        catch (CoreLayerException e) {
            msg = e.getMessage();
        }
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"No menu item matching Matcher matching widgets with text that without mnenomic matches: is \"ShellMenuBarItemX\" was found.\nThe following items were found on path '/':\n\tShellMenuBarItem", (Object)msg);
    }

    @Test
    public void testErrorMessageForNonexistingComplexMenuItem() {
        DefaultShell shell = new DefaultShell("MenuShell");
        ShellMenu menu = new ShellMenu((Shell)shell);
        String msg = null;
        try {
            menu.getItem(new String[]{"ShellMenuBarItem", "ShellMenuBarItem1X"});
        }
        catch (CoreLayerException e) {
            msg = e.getMessage();
        }
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)"No menu item matching Matcher matching widgets with text that without mnenomic matches: is \"ShellMenuBarItem\", Matcher matching widgets with text that without mnenomic matches: is \"ShellMenuBarItem1X\" was found.\nThe following items were found on path '/ShellMenuBarItem':\n\tShellMenuBarItem1", (Object)msg);
    }
}

