/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.annotation;

import java.lang.annotation.Annotation;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.junit.annotation.AnnotationUtils;
import org.eclipse.reddeer.junit.test.annotation.resources.AnotherAnnotation;
import org.eclipse.reddeer.junit.test.annotation.resources.ChildClass;
import org.eclipse.reddeer.junit.test.annotation.resources.ConfigurableTestRequirement;
import org.eclipse.reddeer.junit.test.annotation.resources.CustomMethodAnnotation;
import org.eclipse.reddeer.junit.test.annotation.resources.CustomMethodAnnotation2;
import org.eclipse.reddeer.junit.test.annotation.resources.DefaultTestRequirement;
import org.eclipse.reddeer.junit.test.annotation.resources.GrandChildClass;
import org.eclipse.reddeer.junit.test.annotation.resources.SampleAnnotation;
import org.eclipse.reddeer.junit.test.annotation.resources.SimpleTestClassWithAnnotatedMethod;
import org.eclipse.reddeer.junit.test.annotation.resources.SimpleTestClassWithMorePossibilities1;
import org.eclipse.reddeer.junit.test.annotation.resources.SimpleTestClassWithMorePossibilities2;
import org.eclipse.reddeer.junit.test.annotation.resources.TestClassWithDefRequirement;
import org.eclipse.reddeer.junit.test.annotation.resources.TestClassWithTwoRequirements;
import org.eclipse.reddeer.junit.test.annotation.resources.TopClass;
import org.eclipse.reddeer.junit.test.annotation.resources.YetAnotherAnnotation;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationUtilsTest {
    @Test
    public void testGetTopClassAnnotations() {
        List annotations = AnnotationUtils.getClassLevelAnnotations(TopClass.class);
        Assert.assertTrue((String)"There should be 3 annotation collected from top class ", (annotations.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testGetChildsClassAnnotations() {
        List annotations = AnnotationUtils.getClassLevelAnnotations(ChildClass.class);
        Assert.assertTrue((String)("There should be 3 annotation collected from child class, but there are " + annotations.size() + " annotations"), (annotations.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Annotation SampleAnnotation should override parent annotation.", (boolean)this.getAnnotationValue(SampleAnnotation.class, annotations).equals("child"));
        Assert.assertTrue((String)"Annotation AnotherAnnotation should override parent annotation.", (boolean)this.getAnnotationValue(AnotherAnnotation.class, annotations).equals("child"));
        Assert.assertTrue((String)"Annotation YetAnotherAnnotation should be coming from parent annotation.", (boolean)this.getAnnotationValue(YetAnotherAnnotation.class, annotations).equals("parent"));
    }

    @Test
    public void testGetGrandChildClassAnotations() {
        List annotations = AnnotationUtils.getClassLevelAnnotations(GrandChildClass.class);
        Assert.assertTrue((String)("There should be 3 annotation collected from grandchild class, but there are " + annotations.size() + " annotations"), (annotations.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Annotation SampleAnnotation should come from parent annotation.", (boolean)this.getAnnotationValue(SampleAnnotation.class, annotations).equals("child"));
        Assert.assertTrue((String)"Annotation AnotherAnnotation should come from parent annotation.", (boolean)this.getAnnotationValue(AnotherAnnotation.class, annotations).equals("child"));
        Assert.assertTrue((String)"Annotation YetAnotherAnnotation should override parent annotation.", (boolean)this.getAnnotationValue(YetAnotherAnnotation.class, annotations).equals("grand"));
    }

    @Test
    public void getAnnotationWithNoEnclosingClass() {
        Assert.assertTrue((String)"There should be no enclosing requirement obtained for annotation in separate file", (AnnotationUtils.getEnclosingRequirementClass(AnotherAnnotation.class) == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetDefaultRequirementFromAnnotation() {
        Class clazz = AnnotationUtils.getEnclosingRequirementClass(DefaultTestRequirement.SomeReq.class);
        Assert.assertNotNull((Object)clazz);
        Assert.assertTrue((String)"Requirement class of annotation SomeReq should be DefaultTestRequirement.", (boolean)DefaultTestRequirement.class.isAssignableFrom(clazz));
    }

    @Test
    public void testGetRequirementAnnotation() {
        List annotations = AnnotationUtils.getRequirementAnnotations(TestClassWithDefRequirement.class);
        Assert.assertTrue((String)("There should be obtained 1 requirement class for TestClassWithDefRequirement class, but there is/are " + annotations.size()), (annotations.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testGetRequirementAnnotations() {
        Assert.assertTrue((String)"There should be obtained 2 requirement class for TestClassWithTwoRequirements class", (AnnotationUtils.getRequirementAnnotations(TestClassWithTwoRequirements.class).size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCustomRequirementFromAnnotation() {
        Class clazz = AnnotationUtils.getEnclosingRequirementClass(ConfigurableTestRequirement.ConfigurableTestReq.class);
        Assert.assertNotNull((Object)clazz);
        Assert.assertTrue((String)"Requirement class of annotation SomeReq should be DefaultTestRequirement.", (boolean)ConfigurableTestRequirement.class.isAssignableFrom(clazz));
    }

    @Test
    public void testGetValueOfStaticAnnotatedMethod() {
        String value = (String)AnnotationUtils.invokeStaticMethodWithAnnotation(SimpleTestClassWithAnnotatedMethod.class, CustomMethodAnnotation.class, (Class[])new Class[]{String.class});
        Assert.assertTrue((String)"Value of invoked method should be 'value'.", (boolean)value.equals("value"));
    }

    @Test
    public void testGetValueOfStaticAnnotatedMethodWhichDoesNotExist() {
        String value = (String)AnnotationUtils.invokeStaticMethodWithAnnotation(SimpleTestClassWithAnnotatedMethod.class, CustomMethodAnnotation2.class, (Class[])new Class[]{String.class});
        Assert.assertNull((Object)value);
    }

    @Test
    public void testGetValueOfStaticAnnotatedMethodTwoPossibilities() {
        String value = (String)AnnotationUtils.invokeStaticMethodWithAnnotation(SimpleTestClassWithMorePossibilities1.class, CustomMethodAnnotation.class, (Class[])new Class[]{String.class, Integer.class});
        Assert.assertTrue((String)"Value of invoked method should be 'value'.", (boolean)value.equals("value"));
        Integer value1 = (Integer)AnnotationUtils.invokeStaticMethodWithAnnotation(SimpleTestClassWithMorePossibilities2.class, CustomMethodAnnotation.class, (Class[])new Class[]{String.class, Integer.class});
        Assert.assertTrue((String)"Value of invoked method should be '1'.", (boolean)value1.equals(1));
    }

    @Test(expected=RedDeerException.class)
    public void testGetValueOfStaticAnnotatedMethodWithWrongReturnType() {
        AnnotationUtils.invokeStaticMethodWithAnnotation(SimpleTestClassWithAnnotatedMethod.class, CustomMethodAnnotation.class, (Class[])new Class[]{ChildClass.class});
    }

    private String getAnnotationValue(Class<? extends Annotation> annotationClass, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            if (annotationClass.equals(SampleAnnotation.class)) {
                return ((SampleAnnotation)annotation).someValue();
            }
            if (annotationClass.equals(AnotherAnnotation.class)) {
                return ((AnotherAnnotation)annotation).someValue();
            }
            if (!annotationClass.equals(YetAnotherAnnotation.class)) continue;
            return ((YetAnotherAnnotation)annotation).someValue();
        }
        return "";
    }
}

