/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.integration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.integration.test.installation.common.preferences.AvailableSoftwareSitesPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferenceDialog;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class AvailableSoftwareSitesPreferencePageTest {
    private PreferenceDialog dialog;
    private AvailableSoftwareSitesPreferencePage page;
    private DefaultShell shell = null;
    private static final String ECLIPSE = "Eclipse";
    private static final String ECLIPSE_URL = "https://download.eclipse.org/releases/latest";
    private static final String REDDEER = "RedDeer";
    private static final String REDDEER_URL = "http://download.eclipse.org/reddeer/releases/latest";

    @BeforeClass
    public static void setupList() {
        LinkedHashMap<String, String> sites = new LinkedHashMap<String, String>();
        sites.put(ECLIPSE, ECLIPSE_URL);
        sites.put(REDDEER, REDDEER_URL);
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        AvailableSoftwareSitesPreferencePage page = new AvailableSoftwareSitesPreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)page);
        for (Map.Entry site : sites.entrySet()) {
            page.clickAdd();
            LabeledText name = new LabeledText("Name:");
            name.setText((String)site.getKey());
            LabeledText url = new LabeledText("Location:");
            url.setText((String)site.getValue());
            new PushButton("Add").click();
        }
        dialog.ok();
    }

    @Before
    public void openAvailableSoftwareSitesPreferencePage() {
        this.dialog = new WorkbenchPreferenceDialog();
        this.dialog.open();
        this.page = new AvailableSoftwareSitesPreferencePage((ReferencedComposite)this.dialog);
        this.dialog.select((PreferencePage)this.page);
    }

    @Test
    public void pageIsOpened() {
        Assert.assertTrue((String)"Page does not have right name", (boolean)this.page.getName().contains("Available Software Sites"));
    }

    @Test
    public void getItemsTest() {
        Assert.assertFalse((boolean)this.page.getItems().isEmpty());
    }

    @Test
    public void getItemTest() {
        String itemText = this.page.getItem(ECLIPSE).getText();
        Assert.assertTrue((String)("Item has text " + itemText), (boolean)this.page.getItem(ECLIPSE).getText().contains(ECLIPSE));
    }

    @Test
    public void getItemAlternateSearchTest() {
        String itemText = this.page.getItem(REDDEER_URL, true).getText(1);
        Assert.assertTrue((String)("the item has text " + itemText), (boolean)itemText.contains(REDDEER_URL));
        itemText = this.page.getItem(ECLIPSE, false).getText();
        Assert.assertTrue((String)("the item has text " + itemText), (boolean)itemText.contains(ECLIPSE));
        TableItem item = this.page.getItem(ECLIPSE, true);
        Assert.assertNull((String)"Item is not null", (Object)item);
    }

    @Test
    public void toggleAllItemsTest() {
        this.page.toggleAllItems(false);
        for (TableItem item : this.page.getItems()) {
            Assert.assertFalse((boolean)item.isChecked());
        }
        this.page.toggleAllItems(true);
        for (TableItem item : this.page.getItems()) {
            Assert.assertTrue((boolean)item.isChecked());
        }
    }

    @Test
    public void toggleItemTest() {
        this.page.toggleItem(ECLIPSE, false);
        Assert.assertFalse((boolean)this.page.getItem(ECLIPSE).isChecked());
        this.page.toggleItem(ECLIPSE, true);
        Assert.assertTrue((boolean)this.page.getItem(ECLIPSE).isChecked());
    }

    @Test
    public void toggleItemAlternativeSearchTest() {
        this.page.toggleItem(REDDEER_URL, false, true);
        Assert.assertFalse((boolean)this.page.getItem(REDDEER_URL, true).isChecked());
        this.page.toggleItem(REDDEER_URL, true, true);
        Assert.assertTrue((boolean)this.page.getItem(REDDEER).isChecked());
    }

    @Test
    public void selectItemTest() {
        this.page.selectItem(REDDEER);
        Assert.assertTrue((boolean)this.page.isButtonEnabled("Edit"));
    }

    @Test
    public void selectItemAlternativeSearchTest() {
        this.page.selectItem(ECLIPSE_URL, true);
        Assert.assertTrue((boolean)this.page.isButtonEnabled("Edit"));
    }

    @Test
    public void isItemEnabledTest() {
        Assert.assertTrue((boolean)this.page.isItemEnabled(ECLIPSE));
        this.page.toggleItem(ECLIPSE, false);
        Assert.assertFalse((boolean)this.page.isItemEnabled(ECLIPSE));
    }

    @Test
    public void isItemEnabledAlternativeSearchTest() {
        Assert.assertTrue((boolean)this.page.isItemEnabled(ECLIPSE_URL, true));
        this.page.toggleItem(ECLIPSE, false);
        Assert.assertFalse((boolean)this.page.isItemEnabled(ECLIPSE_URL, true));
    }

    @Test
    public void isButtonEnabledTest() {
        Assert.assertTrue((boolean)this.page.isButtonEnabled("Add..."));
        Assert.assertFalse((boolean)this.page.isButtonEnabled("Edit"));
    }

    @Test
    public void clickAddTest() {
        this.page.clickAdd();
        this.shell = new DefaultShell("Add Site");
        Assert.assertTrue((String)"Shell with title Add Site is not opened", (boolean)this.shell.getText().contains("Add Site"));
    }

    @Test
    public void clickEditTest() {
        this.page.selectItem(ECLIPSE);
        this.page.clickEdit();
        this.shell = new DefaultShell("Edit Site");
        Assert.assertTrue((String)"Shell with title Edit Site is not opened", (boolean)this.shell.getText().contains("Edit Site"));
    }

    @Test
    public void clickRemoveTest() {
        this.page.selectItem(REDDEER);
        this.page.clickRemove();
        this.shell = new DefaultShell("Remove Sites");
        Assert.assertTrue((String)"Shell with title Remove Sites is not opened", (boolean)this.shell.getText().contains("Remove Sites"));
    }

    @Test
    public void clickReloadTest() {
        this.page.selectItem(ECLIPSE);
        this.page.clickReload();
        this.shell = new DefaultShell("Progress Information");
        Assert.assertTrue((String)"Progress Information shell did not open", (boolean)this.shell.getText().contains("Progress Information"));
        new PushButton((ReferencedComposite)this.shell, "Cancel").click();
    }

    @Test
    public void clickEnableTest() {
        this.page.toggleAllItems(false);
        this.page.selectItem(ECLIPSE);
        this.page.clickEnable();
        Assert.assertTrue((String)"Item is not enabled", (boolean)this.page.isItemEnabled(ECLIPSE));
    }

    @Test
    public void clickDisableTest() {
        this.page.selectItem(REDDEER);
        this.page.clickDisable();
        Assert.assertFalse((String)"Item is not disabled", (boolean)this.page.isItemEnabled(REDDEER));
    }

    @After
    public void closeAllShells() {
        if (this.shell != null) {
            this.shell.close();
        }
        this.dialog.cancel();
    }
}

