/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.wait;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.Wait;

public abstract class AbstractWait
implements Wait {
    private static final Logger log = Logger.getLogger(AbstractWait.class);
    private static final long DEFAULT_TICK_PERIOD = 500L;
    private TimePeriod timeout;
    private boolean throwTimeoutException = true;

    public AbstractWait(WaitCondition condition) {
        this(condition, TimePeriod.DEFAULT);
    }

    public AbstractWait(WaitCondition condition, TimePeriod timePeriod) {
        this(condition, timePeriod, true);
    }

    public AbstractWait(WaitCondition condition, boolean throwRuntimeException) {
        this(condition, TimePeriod.DEFAULT, throwRuntimeException);
    }

    public AbstractWait(WaitCondition condition, TimePeriod timePeriod, boolean throwRuntimeException) {
        this(condition, timePeriod, throwRuntimeException, 500L);
    }

    public AbstractWait(WaitCondition condition, TimePeriod timePeriod, boolean throwRuntimeException, long testPeriod) {
        if (condition == null) {
            throw new IllegalArgumentException("condition can't be null");
        }
        if (timePeriod == null) {
            throw new IllegalArgumentException("timePeriod can't be null");
        }
        if (testPeriod < 0L) {
            throw new IllegalArgumentException("testPeriod can't be lesser than 0 milliseconds.");
        }
        this.timeout = timePeriod;
        this.throwTimeoutException = throwRuntimeException;
        this.wait(condition, testPeriod);
    }

    @Override
    public void wait(WaitCondition condition, long testPeriod) {
        log.debug(String.valueOf(this.description()) + condition.description() + "...");
        long limit = (Long.MAX_VALUE - System.currentTimeMillis()) / 1000L > this.getTimeout().getSeconds() ? System.currentTimeMillis() + this.getTimeout().getSeconds() * 1000L : Long.MAX_VALUE;
        while (!this.stopWaiting(condition)) {
            if (this.timeoutExceeded(condition, limit)) {
                return;
            }
            AbstractWait.sleep(testPeriod);
        }
        log.debug(String.valueOf(this.description()) + condition.description() + " finished successfully");
    }

    protected TimePeriod getTimeout() {
        return this.timeout;
    }

    protected boolean throwTimeoutException() {
        return this.throwTimeoutException;
    }

    public static void sleep(TimePeriod timePeriod) {
        log.debug("Wait for " + timePeriod.getSeconds() + " seconds");
        AbstractWait.sleep(timePeriod.getSeconds() * 1000L);
    }

    private static void sleep(long milliseconds) {
        if (Thread.currentThread().equals(Display.getDisplay().getThread())) {
            throw new RuntimeException("Tried to execute sleep in UI thread!");
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Sleep interrupted", e);
        }
    }

    private boolean timeoutExceeded(WaitCondition condition, long limit) {
        if (System.currentTimeMillis() > limit) {
            if (this.throwTimeoutException()) {
                log.debug(String.valueOf(this.description()) + condition.description() + " failed, an exception will be thrown");
                this.throwWaitTimeOutException(this.timeout, condition);
            } else {
                log.debug(String.valueOf(this.description()) + condition.description() + " failed, NO exception will be thrown");
                return true;
            }
        }
        return false;
    }

    protected void throwWaitTimeOutException(TimePeriod timeout, WaitCondition condition) {
        throw new WaitTimeoutExpiredException("Timeout after: " + timeout.getSeconds() + " s.: " + condition.description());
    }
}

