/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.wait;

import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitType;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;

public class GroupWait {
    private TimePeriod remainingTimeout;

    public GroupWait(TimePeriod timeout, WaitWrapper ... waitings) {
        this.remainingTimeout = timeout;
        if (waitings == null || waitings.length == 0) {
            throw new IllegalArgumentException("There are no waiting to wait for, pass one or more waitings as a constructor arguments to start waiting");
        }
        WaitWrapper[] waitWrapperArray = waitings;
        int n = waitings.length;
        int n2 = 0;
        while (n2 < n) {
            WaitWrapper waitWrapper = waitWrapperArray[n2];
            long startTimeOfWait = System.currentTimeMillis();
            if (WaitType.WHILE.equals((Object)waitWrapper.getWaitType())) {
                new WaitWhile(waitWrapper.getWaitCondition(), this.remainingTimeout, waitWrapper.throwRuntimeException());
            } else if (WaitType.UNTIL.equals((Object)waitWrapper.getWaitType())) {
                new WaitUntil(waitWrapper.getWaitCondition(), this.remainingTimeout, waitWrapper.throwRuntimeException());
            }
            this.remainingTimeout = this.getRemainingTimeoutPeriod(this.remainingTimeout, startTimeOfWait);
            ++n2;
        }
    }

    public GroupWait(WaitWrapper ... waitings) {
        this(TimePeriod.DEFAULT, waitings);
    }

    public TimePeriod getRemainingTimeout() {
        return this.remainingTimeout;
    }

    private TimePeriod getRemainingTimeoutPeriod(TimePeriod oldTimeout, long startTimeOfWait) {
        long diffTime = Math.round((System.currentTimeMillis() - startTimeOfWait) / 1000L);
        long remainingTimeout = oldTimeout.getSeconds() - diffTime;
        if (remainingTimeout <= 0L) {
            return TimePeriod.NONE;
        }
        return TimePeriod.getCustom(remainingTimeout);
    }
}

