/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.lookup;

import java.util.Arrays;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.MenuHandler;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.hamcrest.Matcher;

public class MenuItemLookup {
    private static final Logger log = Logger.getLogger(MenuItemLookup.class);
    private static MenuItemLookup instance = null;

    private MenuItemLookup() {
    }

    public static MenuItemLookup getInstance() {
        if (instance == null) {
            instance = new MenuItemLookup();
        }
        return instance;
    }

    public MenuItem lookFor(Menu menu, Matcher<String> ... matchers) {
        List<MenuItem> items = MenuHandler.getInstance().getItems(menu);
        MenuItem lastMenuItem = this.getMatchingMenuPath(items, matchers);
        if (lastMenuItem == null) {
            throw new CoreLayerException("No menu item matching specified path found");
        }
        return lastMenuItem;
    }

    private MenuItem getMatchingMenuPath(final List<MenuItem> topItems, final Matcher<String> ... matchers) {
        MenuItem i = (MenuItem)Display.syncExec((ResultRunnable)new ResultRunnable<MenuItem>(){

            public MenuItem run() {
                Menu currentMenu = null;
                MenuItem currentItem = null;
                List<MenuItem> menuItems = topItems;
                Matcher[] matcherArray = matchers;
                int n = matchers.length;
                int n2 = 0;
                while (n2 < n) {
                    Matcher m = matcherArray[n2];
                    currentItem = null;
                    for (MenuItem i : menuItems) {
                        String normalized = i.getText().replace("&", "");
                        log.debug("Found menu:'" + normalized + "'");
                        if (!m.matches((Object)normalized)) continue;
                        log.debug("Item match:" + normalized);
                        currentItem = i;
                        currentMenu = i.getMenu();
                        break;
                    }
                    if (currentItem == null) {
                        return null;
                    }
                    if (m != matchers[matchers.length - 1]) {
                        currentMenu = currentItem.getMenu();
                        MenuHandler.getInstance().sendShowUI((Widget)currentMenu);
                        menuItems = Arrays.asList(currentMenu.getItems());
                    }
                    ++n2;
                }
                return currentItem;
            }
        });
        return i;
    }
}

