/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.junit;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.junit.ui.TestRunnerViewPart;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.FinishButton;
import org.eclipse.reddeer.swt.impl.button.NextButton;
import org.eclipse.reddeer.swt.impl.list.DefaultList;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class JUnitRunTest {
    private static final String PROJECT_NAME = "hellotest";

    @BeforeClass
    public static void createTestProject() {
        JavaProjectWizard projectWizard = new JavaProjectWizard();
        projectWizard.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)projectWizard).setProjectName(PROJECT_NAME);
        projectWizard.finish();
        NewClassCreationWizard classWizard = new NewClassCreationWizard();
        classWizard.open();
        new NewClassWizardPage((ReferencedComposite)classWizard).setName("HelloTest");
        classWizard.finish();
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).select();
        new ContextMenuItem(new String[]{"Build Path", "Add Libraries..."}).select();
        new DefaultShell("Add Library");
        new DefaultList().select("JUnit");
        new NextButton().click();
        new FinishButton().click();
        new WaitWhile((WaitCondition)new ShellIsAvailable("Add Library"));
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{"src", PROJECT_NAME, "HelloTest.java"}).open();
        TextEditor editor = new TextEditor("HelloTest.java");
        editor.setText("package hellotest;\n\nimport org.junit.After;\nimport org.junit.Assert;\nimport org.junit.Test;\n\npublic class HelloTest {\n\n\t@Test\n\tpublic void badTest() {\n\t\tAssert.assertEquals(5, 2 + 2);\n\t}\n\n\t@Test\n\tpublic void veryBadTest() {\n\t\tthrow new RuntimeException();\n\t}\n\n\t@After\n\tpublic void waitAfter() throws Exception {\n\t\tThread.sleep(5000);\n\t}\n}");
        editor.save();
        editor.close();
    }

    @AfterClass
    public static void deleteTestProject() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)explorer.getProject(PROJECT_NAME), (boolean)true);
    }

    @Test
    public void junitRunTest() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(PROJECT_NAME).getProjectItem(new String[]{"src", PROJECT_NAME, "HelloTest.java"}).runAsJUnitTest();
        TestRunnerViewPart junitView = new TestRunnerViewPart();
        junitView.open();
        Assert.assertEquals((Object)"2/2", (Object)junitView.getRunStatus());
        Assert.assertEquals((long)1L, (long)junitView.getNumberOfErrors());
        Assert.assertEquals((long)1L, (long)junitView.getNumberOfFailures());
    }
}

