/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.ide;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.ide.ExtendedFileEditorsPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ExtendedFileEditorsPreferencePageTest {
    private static final String TEST_FILE_TYPE = "myFileType";
    private ExtendedFileEditorsPreferencePage prefPage;
    private WorkbenchPreferenceDialog prefDialog;

    @Before
    public void setup() {
        this.prefPage = new ExtendedFileEditorsPreferencePage((ReferencedComposite)this.prefDialog);
        this.prefDialog = new WorkbenchPreferenceDialog();
        this.prefDialog.open();
        this.prefDialog.select((PreferencePage)this.prefPage);
    }

    @After
    public void teardown() {
        this.prefDialog.cancel();
    }

    @Test
    public void selectFileTypeTest() {
        this.prefPage.selectFileType("*.html");
        DefaultTable defaultTable = new DefaultTable();
        List selectetItems = defaultTable.getSelectetItems();
        Assert.assertEquals((String)"Only one item should be selected", (long)1L, (long)selectetItems.size());
        Assert.assertTrue((String)"*.html file type should be selected", (boolean)((TableItem)selectetItems.get(0)).getText().equals("*.html"));
    }

    @Test
    public void addFileTypeTest() {
        this.prefPage.addFileType(TEST_FILE_TYPE);
        Assert.assertTrue((boolean)new DefaultTable().containsItem(TEST_FILE_TYPE));
        new DefaultTable().getItem(TEST_FILE_TYPE).select();
        new PushButton("Remove").click();
    }

    @Test
    public void removeFileTypeTest() {
        this.prefPage.addFileType(TEST_FILE_TYPE);
        this.prefPage.removeFileType(TEST_FILE_TYPE);
        Assert.assertFalse((boolean)new DefaultTable().containsItem(TEST_FILE_TYPE));
    }

    @Test
    public void addEditorTest() {
        this.prefPage.addFileType(TEST_FILE_TYPE);
        this.prefPage.selectFileType(TEST_FILE_TYPE);
        Assert.assertEquals((String)"There should be no editor.", (long)0L, (long)new DefaultTable(1, new Matcher[0]).getItems().size());
        this.prefPage.addAssociatedEditor("Java Editor");
        Assert.assertEquals((String)"There should be one editor.", (long)1L, (long)new DefaultTable(1, new Matcher[0]).getItems().size());
    }

    @Test
    public void removeEditorTest() {
        this.prefPage.addFileType(TEST_FILE_TYPE);
        this.prefPage.selectFileType(TEST_FILE_TYPE);
        this.prefPage.addAssociatedEditor("Java Editor");
        Assert.assertEquals((String)"There should be no editor.", (long)1L, (long)new DefaultTable(1, new Matcher[0]).getItems().size());
        this.prefPage.removeAssociatedEditor("Java Editor");
        Assert.assertEquals((String)"There should be one editor.", (long)0L, (long)new DefaultTable(1, new Matcher[0]).getItems().size());
    }

    @Test
    public void getAssociatedEditorsTest() {
        this.prefPage.selectFileType("*.html");
        List associatedEditors = this.prefPage.getAssociatedEditors();
        Assert.assertEquals((String)"There should be 4 associated editors to *.html", (long)4L, (long)associatedEditors.size());
    }

    @Test
    public void getAssociatedEditorsForFileTypeTest() {
        List associatedEditors = this.prefPage.getAssociatedEditorForFileType("*.html");
        Assert.assertEquals((String)"There should be 4 associated editors to *.html", (long)4L, (long)associatedEditors.size());
    }
}

