/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.core.resources;

import org.eclipse.reddeer.common.adaptable.RedDeerAdaptable;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.matcher.WithStyleMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.direct.preferences.Preferences;
import org.eclipse.reddeer.direct.project.Project;
import org.eclipse.reddeer.eclipse.condition.JUnitHasFinished;
import org.eclipse.reddeer.eclipse.core.resources.Resource;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyDialog;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.jface.handler.TreeViewerHandler;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.handler.WorkbenchPartHandler;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public abstract class AbstractResource
implements Resource,
RedDeerAdaptable<Resource> {
    protected Logger logger = new Logger(AbstractResource.class);
    protected TreeItem treeItem;
    protected TreeViewerHandler treeViewerHandler = TreeViewerHandler.getInstance();

    public AbstractResource(TreeItem treeItem) {
        if (treeItem == null) {
            throw new IllegalArgumentException("Tree item of the resource cannot be null.");
        }
        this.treeItem = treeItem;
    }

    @Override
    public TreeItem getTreeItem() {
        return this.treeItem;
    }

    @Override
    public void open() {
        this.select();
        this.treeItem.doubleClick();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    @Override
    public void refresh() {
        this.select();
        new ContextMenuItem(new String[]{"Refresh"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
    }

    @Override
    public void expand() {
        this.treeItem.expand();
    }

    @Override
    public void collapse() {
        this.treeItem.collapse();
    }

    @Override
    public boolean isExpanded() {
        return this.treeItem.isExpanded();
    }

    @Override
    public String getText() {
        return this.treeItem.getText();
    }

    @Override
    public void select() {
        this.treeItem.select();
    }

    @Override
    public boolean isSelected() {
        return this.treeItem.isSelected();
    }

    @Override
    public boolean containsResource(String ... path) {
        this.activateWrappingView();
        try {
            this.getResource(path);
            return true;
        }
        catch (EclipseLayerException eclipseLayerException) {
            return false;
        }
    }

    @Override
    public void runAs(String launcher) {
        this.select();
        WithMnemonicTextMatcher launcherMatcher = new WithMnemonicTextMatcher((Matcher)new RegexMatcher("[0-9]* " + launcher));
        new ContextMenuItem(new Matcher[]{new WithMnemonicTextMatcher("Run As"), new WithMnemonicTextMatcher((Matcher)launcherMatcher)}).select();
    }

    @Override
    public void runAsJUnitTest() {
        this.runAsJUnitTest(TimePeriod.LONG);
    }

    @Override
    public void runAsJUnitTest(TimePeriod timeout) {
        String consoleOpenOnErr = Preferences.get((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnErr");
        String consoleOpenOnOut = Preferences.get((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnOut");
        Preferences.set((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnErr", (String)"false");
        Preferences.set((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnOut", (String)"false");
        this.runAs("JUnit Test");
        new GroupWait(timeout, new WaitWrapper[]{WaitProvider.waitWhile((WaitCondition)new JUnitHasFinished()), WaitProvider.waitUntil((WaitCondition)new JUnitHasFinished())});
        Preferences.set((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnErr", (String)consoleOpenOnErr);
        Preferences.set((String)"org.eclipse.debug.ui", (String)"DEBUG.consoleOpenOnOut", (String)consoleOpenOnOut);
    }

    @Override
    public void debugAs(String launcher) {
        this.select();
        WithMnemonicTextMatcher launcherMatcher = new WithMnemonicTextMatcher((Matcher)new RegexMatcher("[0-9]* " + launcher));
        new ContextMenuItem(new Matcher[]{new WithMnemonicTextMatcher("Debug As"), new WithMnemonicTextMatcher((Matcher)launcherMatcher)}).select();
    }

    @Override
    public void delete() {
        this.deleteResource(true);
    }

    public Object[] getAdapterConstructorArguments() {
        return new Object[]{this.treeItem};
    }

    public Class<?>[] getAdapterConstructorClasses() {
        return new Class[]{TreeItem.class};
    }

    protected void deleteResource(boolean deleteFromFileSystem) {
        String parentTreeItemText = this.treeItem.getPath()[0];
        if (Project.isProject((String)parentTreeItemText) && Project.isOpen((String)parentTreeItemText)) {
            this.refresh();
        }
        this.logger.debug("Delete resource'" + this.getName() + "' via Explorer");
        this.select();
        new ContextMenuItem(new String[]{"Delete"}).select();
        Shell sDeleteResources = this.handleDeleteResourcesShell(deleteFromFileSystem);
        if (sDeleteResources == null && this.treeItem != null && !this.treeItem.isDisposed()) {
            this.logger.debug("Delete resource '" + this.getName() + "' via Workbench menu");
            this.treeItem.select();
            new ShellMenuItem(new String[]{"Edit", "Delete"}).select();
            sDeleteResources = this.handleDeleteResourcesShell(deleteFromFileSystem);
        }
        if (sDeleteResources == null) {
            throw new EclipseLayerException("Unable to delete project " + this.getName() + " via UI calls");
        }
        new OkButton().click();
        DeleteUtils.handleDeletion(sDeleteResources, TimePeriod.VERY_LONG);
    }

    protected Shell handleDeleteResourcesShell(boolean deleteFromFileSystem) {
        DefaultShell sDeleteResources = null;
        try {
            sDeleteResources = new DefaultShell(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher("Delete.*"))});
            if (new WidgetIsFound(Button.class, sDeleteResources.getControl(), 0, new Matcher[]{new WithStyleMatcher(32)}).test()) {
                new CheckBox().toggle(deleteFromFileSystem);
            }
        }
        catch (SWTLayerException sWTLayerException) {
            sDeleteResources = null;
        }
        return sDeleteResources;
    }

    @Override
    public String[] getDecoratedParts() {
        return this.treeViewerHandler.getStyledTexts(this.treeItem);
    }

    @Override
    public String getName() {
        return this.treeViewerHandler.getNonStyledText(this.treeItem);
    }

    @Override
    public String getTitleOfWrappingView() {
        return WorkbenchPartHandler.getInstance().getTitleOfWorkbenchPartWithWidget(this.treeItem.getSWTWidget());
    }

    @Override
    public void activateWrappingView() {
        WorkbenchPartHandler.getInstance().activateWorkbenchPartWithWidget(this.treeItem.getSWTWidget());
    }

    @Override
    public PropertyDialog openProperties() {
        this.select();
        new ContextMenuItem(new String[]{"Properties"}).select();
        return new PropertyDialog(this.getText());
    }
}

