/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public abstract class ExtensibleProfileDetailsWizardPage
extends WizardPage {
    public static final String LABEL_DRIVER = "Drivers:";

    protected ExtensibleProfileDetailsWizardPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public boolean testConnection() {
        try {
            DefaultShell shell = new DefaultShell("Success");
            new OkButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)shell));
            return true;
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            WidgetIsFound widgetIsFound = new WidgetIsFound(Shell.class, new Matcher[]{new WithTextMatcher("Error")});
            if (widgetIsFound.test()) {
                new OkButton().click();
                new WaitWhile((WaitCondition)new ShellIsAvailable((org.eclipse.reddeer.swt.api.Shell)new DefaultShell((Shell)widgetIsFound.getResult())));
                return false;
            }
            throw new RedDeerException("Something went wrong and nor Success nor Error shell were shown.  Cannot handle this exceptional situation.");
        }
    }

    public String getDriver() {
        return new LabeledCombo(this.referencedComposite, LABEL_DRIVER).getText();
    }

    public ExtensibleProfileDetailsWizardPage setDriver(String driver) {
        new LabeledCombo(this.referencedComposite, LABEL_DRIVER).setSelection(driver);
        return this;
    }

    public String getDatabase() {
        return new LabeledText(this.referencedComposite, this.getDatabaseLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setDatabase(String database) {
        new LabeledText(this.referencedComposite, this.getDatabaseLabel()).setText(database);
        return this;
    }

    public String getHostname() {
        return new LabeledText(this.referencedComposite, this.getHostnameLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setHostname(String hostname) {
        new LabeledText(this.referencedComposite, this.getHostnameLabel()).setText(hostname);
        return this;
    }

    public String getURL() {
        return new LabeledText(this.referencedComposite, this.getURLLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setURL(String URL2) {
        new LabeledText(this.referencedComposite, this.getURLLabel()).setText(URL2);
        return this;
    }

    public String getUsername() {
        return new LabeledText(this.referencedComposite, this.getUsernameLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setUsername(String userName) {
        new LabeledText(this.referencedComposite, this.getUsernameLabel()).setText(userName);
        return this;
    }

    public String getPort() {
        return new LabeledText(this.referencedComposite, this.getPortLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setPort(String port) {
        new LabeledText(this.referencedComposite, this.getPortLabel()).setText(port);
        return this;
    }

    public String getPassword() {
        return new LabeledText(this.referencedComposite, this.getPasswordLabel()).getText();
    }

    public ExtensibleProfileDetailsWizardPage setPassword(String password) {
        new LabeledText(this.referencedComposite, this.getPasswordLabel()).setText(password);
        return this;
    }

    public ExtensibleProfileDetailsWizardPage toggleSavePassword(boolean toggle) {
        new CheckBox(this.referencedComposite, this.getSavePasswordLabel()).click();
        return this;
    }

    protected abstract String getHostnameLabel();

    protected abstract String getDatabaseLabel();

    protected abstract String getURLLabel();

    protected abstract String getUsernameLabel();

    protected abstract String getPortLabel();

    protected abstract String getPasswordLabel();

    protected abstract String getSavePasswordLabel();
}

