/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.debug.ui.preferences;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class ConsolePreferencePage
extends PreferencePage {
    public static final String CATEGORY = "Run/Debug";
    public static final String PAGE_NAME = "Console";
    public static final String LIMIT_OUTPUT = "Limit console output";
    public static final String CONSOLE_SIZE = "Console buffer size (characters):";
    public static final String SHOW_ON_OUTPUT = "Show when program writes to standard out";
    public static final String SHOW_ON_ERROR = "Show when program writes to standard error";

    public ConsolePreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{CATEGORY, PAGE_NAME});
    }

    public boolean isConsoleOutputLimited() {
        return new CheckBox(this.referencedComposite, LIMIT_OUTPUT).isChecked();
    }

    public ConsolePreferencePage toggleConsoleOutputLimited(boolean checked) {
        new CheckBox(this.referencedComposite, LIMIT_OUTPUT).toggle(checked);
        return this;
    }

    public int getConsoleOutputSize() {
        return Integer.valueOf(new LabeledText(this.referencedComposite, CONSOLE_SIZE).getText());
    }

    public ConsolePreferencePage setConsoleOutputSize(int size) {
        this.toggleConsoleOutputLimited(true);
        new LabeledText(this.referencedComposite, CONSOLE_SIZE).setText(String.valueOf(size));
        return this;
    }

    public boolean isConsoleOpenedOnOutput() {
        return new CheckBox(this.referencedComposite, SHOW_ON_OUTPUT).isChecked();
    }

    public ConsolePreferencePage toggleShowConsoleOnOutput(boolean checked) {
        new CheckBox(this.referencedComposite, SHOW_ON_OUTPUT).toggle(checked);
        return this;
    }

    public boolean isConsoleOpenedOnError() {
        return new CheckBox(this.referencedComposite, SHOW_ON_ERROR).isChecked();
    }

    public ConsolePreferencePage toggleShowConsoleErrorWrite(boolean checked) {
        new CheckBox(this.referencedComposite, SHOW_ON_ERROR).toggle(checked);
        return this;
    }
}

