/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.epp.logging.aeri.ide.dialogs.SetupWizard;
import org.eclipse.reddeer.swt.api.Combo;
import org.eclipse.reddeer.swt.api.Group;
import org.eclipse.reddeer.swt.api.Text;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.group.DefaultGroup;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class PreferencePage
extends org.eclipse.reddeer.jface.preference.PreferencePage {
    public static final String CATEGORY = "General";
    public static final String PAGE_NAME = "Error Reporting";

    public PreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{CATEGORY, PAGE_NAME});
    }

    public PreferencePage setName(String name) {
        this.getNameWidget().setText(name);
        return this;
    }

    public PreferencePage setEmail(String email) {
        this.getEmailWidget().setText(email);
        return this;
    }

    public String getName() {
        return this.getNameWidget().getText();
    }

    public String getEmail() {
        return this.getEmailWidget().getText();
    }

    public PreferencePage anonymizePackageClassMethodNames(boolean toggle) {
        this.getAnonymizePackageWidget().toggle(toggle);
        return this;
    }

    public boolean isAnonymizePackageClassMethodNames() {
        return this.getAnonymizePackageWidget().isChecked();
    }

    public PreferencePage anonymizeErrorLogMessages(boolean toggle) {
        this.getAnonymizeErrorWidget().toggle(toggle);
        return this;
    }

    public boolean isAnonymizeErrorLogMessages() {
        return this.getAnonymizeErrorWidget().isChecked();
    }

    public PreferencePage disableExtendedClasspathAnalysis(boolean toggle) {
        this.getDisableAnalysisWidget().toggle(toggle);
        return this;
    }

    public boolean isDisableExtendedClasspathAnalysis() {
        return this.getDisableAnalysisWidget().isChecked();
    }

    public PreferencePage enableDebugMode(boolean toggle) {
        this.getDebugModeWidget().toggle(toggle);
        return this;
    }

    public boolean isEnableDebugMode() {
        return this.getDebugModeWidget().isChecked();
    }

    public PreferencePage setSendMode(String sendMode) {
        this.getSendModeWidget().setSelection(sendMode);
        return this;
    }

    public String getSendMode() {
        return this.getSendModeWidget().getSelection();
    }

    public List<String> getAvailableSendModes() {
        return this.getSendModeWidget().getItems();
    }

    public SetupWizard openConfigureProjects() {
        new PushButton(this.referencedComposite, "Configure Projects\u2026").click();
        return new SetupWizard();
    }

    protected Group getSendOptionsGroup() {
        return new DefaultGroup(this.referencedComposite, "Send Options");
    }

    protected Group getContactGroup() {
        return new DefaultGroup(this.referencedComposite, "Contact Information");
    }

    protected Text getNameWidget() {
        return new LabeledText((ReferencedComposite)this.getContactGroup(), "Name:");
    }

    protected Text getEmailWidget() {
        return new LabeledText((ReferencedComposite)this.getContactGroup(), "E\u2010mail:");
    }

    protected CheckBox getAnonymizePackageWidget() {
        return new CheckBox((ReferencedComposite)this.getSendOptionsGroup(), "Anonymize package, class, and method names");
    }

    protected CheckBox getAnonymizeErrorWidget() {
        return new CheckBox((ReferencedComposite)this.getSendOptionsGroup(), "Anonymize error log messages");
    }

    protected CheckBox getDisableAnalysisWidget() {
        return new CheckBox((ReferencedComposite)this.getSendOptionsGroup(), "Disable extended classpath analysis");
    }

    protected CheckBox getDebugModeWidget() {
        return new CheckBox(this.referencedComposite, "Enable debug mode");
    }

    protected Combo getSendModeWidget() {
        return new LabeledCombo(this.referencedComposite, "Send mode:");
    }
}

