/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.jdt.ui.dialogs.ClassField;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;

public class GenerateHashCodeEqualsDialog {
    private Shell shell;

    public void open(boolean viaShellMenu) {
        if (viaShellMenu) {
            new ShellMenuItem(new String[]{"Source", "Generate hashCode() and equals()..."}).select();
        } else {
            new ContextMenuItem(new String[]{"Source", "Generate hashCode() and equals()..."}).select();
        }
        this.shell = new DefaultShell("Generate hashCode() and equals()");
    }

    public List<ClassField> getFields() {
        ArrayList<ClassField> fields = new ArrayList<ClassField>();
        for (TreeItem i : new DefaultTree().getAllItems()) {
            fields.add(new ClassField(i));
        }
        return fields;
    }

    public List<String> getInsertionPoint() {
        return new LabeledCombo("Insertion points:").getItems();
    }

    public void setInsertionPoint(String insertionPoint) {
        new LabeledCombo("Insertion points:").setSelection(insertionPoint);
    }

    public boolean isGenerateMethodComments() {
        return new CheckBox("Generate method comments").isChecked();
    }

    public boolean isUseInstanceofToCompareTypes() {
        return new CheckBox("Use 'instanceof' to compare types").isChecked();
    }

    public boolean isUseBlocksInIfStatements() {
        return new CheckBox("Use blocks in 'if' statements").isChecked();
    }

    public void toggleGenerateMethodComments(boolean toggle) {
        new CheckBox("Generate method comments").toggle(toggle);
    }

    public void toggleUseInstanceofToCompareTypes(boolean toggle) {
        new CheckBox("Use 'instanceof' to compare types").toggle(toggle);
    }

    public void toggleUseBlocksInIfStatements(boolean toggle) {
        new CheckBox("Use blocks in 'if' statements").toggle(toggle);
    }

    public void selectAll() {
        new PushButton("Select All").click();
    }

    public void deselectAll() {
        new PushButton("Deselect All").click();
    }

    public void ok() {
        String shellText = this.shell.getText();
        new PushButton("OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(shellText));
    }

    public void cancel() {
        String shellText = this.shell.getText();
        new PushButton("Cancel").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable(shellText));
    }
}

