/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;

public class MavenArchetypesPreferencePage
extends PreferencePage {
    private static final String ADD_LOCAL_CATALOG = "Add Local Catalog...";
    private static final String ADD_REMOTE_CATALOG = "Add Remote Catalog...";
    private static final String EDIT_CATALOG = "Edit...";
    private static final String REMOVE_CATALOG = "Remove";
    private static final String LOCAL_CATALOG_SHELL = "Local Archetype Catalog";
    private static final String REMOTE_CATALOG_SHELL = "Remote Archetype Catalog";
    private static final String CATALOG_DESCRIPTION = "Description:";
    private static final String VERIFY_BUTTON = "Verify...";
    private static final Logger log = Logger.getLogger(MavenArchetypesPreferencePage.class);

    public MavenArchetypesPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Maven", "Archetypes"});
    }

    public MavenArchetypesPreferencePage addLocalCatalog(String catalogFile, String description) {
        new PushButton(this.referencedComposite, ADD_LOCAL_CATALOG).click();
        DefaultShell localCatalogShell = new DefaultShell(LOCAL_CATALOG_SHELL);
        new DefaultCombo((ReferencedComposite)localCatalogShell).setText(catalogFile);
        new LabeledText((ReferencedComposite)localCatalogShell, CATALOG_DESCRIPTION).setText(description);
        new OkButton((ReferencedComposite)localCatalogShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)localCatalogShell));
        return this;
    }

    public String addRemoteCatalog(String catalogFileURL, String description) {
        return this.addRemoteCatalog(catalogFileURL, description, true);
    }

    public String addRemoteCatalog(String catalogFileURL, String description, boolean verify) {
        String verificationResult = "";
        new PushButton(this.referencedComposite, ADD_REMOTE_CATALOG).click();
        DefaultShell remoteCatalogShell = new DefaultShell(REMOTE_CATALOG_SHELL);
        new DefaultCombo((ReferencedComposite)remoteCatalogShell).setText(catalogFileURL);
        new LabeledText((ReferencedComposite)remoteCatalogShell, CATALOG_DESCRIPTION).setText(description);
        if (verify) {
            verificationResult = this.verifyURL((ReferencedComposite)remoteCatalogShell);
        }
        log.info(verificationResult);
        new OkButton((ReferencedComposite)remoteCatalogShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)remoteCatalogShell));
        return verificationResult;
    }

    public List<TableItem> getCatalogs() {
        DefaultTable table = new DefaultTable(this.referencedComposite);
        return table.getItems();
    }

    public List<String> getCatalogNames() {
        ArrayList<String> catalogNames = new ArrayList<String>();
        for (TableItem item : this.getCatalogs()) {
            catalogNames.add(item.getText());
        }
        return catalogNames;
    }

    public MavenArchetypesPreferencePage removeCatalog(String catalogName) {
        this.selectCatalog(catalogName);
        new PushButton(this.referencedComposite, REMOVE_CATALOG).click();
        return this;
    }

    public MavenArchetypesPreferencePage editLocalCatalog(String catalogName, String catalogFile, String description) {
        this.editCatalog(catalogName, catalogFile, description, false);
        return this;
    }

    public String editRemoteCatalog(String catalogName, String catalogFile, String description) {
        return this.editCatalog(catalogName, catalogFile, description, true);
    }

    public String editRemoteCatalog(String catalogName, String catalogFile, String description, boolean verify) {
        return this.editCatalog(catalogName, catalogFile, description, verify);
    }

    private String editCatalog(String catalogName, String catalogFile, String description, boolean verify) {
        String verificationResult = "";
        this.selectCatalog(catalogName);
        new PushButton(this.referencedComposite, EDIT_CATALOG).click();
        DefaultShell editShell = new DefaultShell(new Matcher[]{new WithTextMatcher((Matcher)new RegexMatcher(".* Archetype Catalog"))});
        new DefaultCombo((ReferencedComposite)editShell).setText(catalogFile);
        new LabeledText((ReferencedComposite)editShell, CATALOG_DESCRIPTION).setText(description);
        if (verify) {
            verificationResult = this.verifyURL((ReferencedComposite)editShell);
        }
        log.info(verificationResult);
        new OkButton((ReferencedComposite)editShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)editShell));
        return verificationResult;
    }

    public boolean containsCatalog(String catalogName) {
        for (String name : this.getCatalogNames()) {
            if (!name.equals(catalogName)) continue;
            return true;
        }
        return false;
    }

    public MavenArchetypesPreferencePage selectCatalog(String catalogName) {
        for (TableItem item : this.getCatalogs()) {
            if (!item.getText().equals(catalogName)) continue;
            item.select();
        }
        return this;
    }

    protected String verifyURL(ReferencedComposite composite) {
        new PushButton(composite, VERIFY_BUTTON).click();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        LabeledText labeledText = new LabeledText(composite, REMOTE_CATALOG_SHELL);
        String text = labeledText.getText();
        return text;
    }
}

