/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.preferences;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;

public class MavenSettingsPreferencePage
extends PreferencePage {
    private static final String UPDATE_SETTINGS = "Update Settings";
    private static final String REINDEX = "Reindex";

    public MavenSettingsPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Maven", "User Settings"});
    }

    public MavenSettingsPreferencePage updateSettings() {
        new PushButton(this.referencedComposite, UPDATE_SETTINGS).click();
        new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        return this;
    }

    public MavenSettingsPreferencePage setUserSettingsLocation(String path) {
        this.getSettingsXMLTextWidget().setText(path);
        return this;
    }

    public String getUserSettingsLocation() {
        return this.getSettingsXMLTextWidget().getText();
    }

    public MavenSettingsPreferencePage reindex() {
        new PushButton(this.referencedComposite, REINDEX).click();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
        return this;
    }

    private DefaultText getSettingsXMLTextWidget() {
        final PushButton button = new PushButton(this.referencedComposite, UPDATE_SETTINGS);
        return (DefaultText)Display.syncExec((ResultRunnable)new ResultRunnable<DefaultText>(){

            public DefaultText run() {
                return new DefaultText(new ReferencedComposite(){

                    public Control getControl() {
                        return ((Button)button.getSWTWidget()).getParent();
                    }
                }, 1, new Matcher[0]);
            }
        });
    }
}

