/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.hamcrest.Matcher;

public class ExtendedFileEditorsPreferencePage
extends PreferencePage {
    public ExtendedFileEditorsPreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"General", "Editors", "File Associations"});
    }

    public List<String> getFileTypes() {
        ArrayList<String> resultList = new ArrayList<String>();
        DefaultTable fileTypesTable = new DefaultTable(this.referencedComposite);
        List fileTypeItems = fileTypesTable.getItems();
        for (TableItem tableItem : fileTypeItems) {
            resultList.add(tableItem.getText());
        }
        return resultList;
    }

    public ExtendedFileEditorsPreferencePage selectFileType(String fileType) {
        DefaultTable fileTypesTable = new DefaultTable(this.referencedComposite);
        TableItem item = fileTypesTable.getItem(fileType);
        item.select();
        return this;
    }

    public ExtendedFileEditorsPreferencePage addFileType(String fileType) {
        new PushButton(this.referencedComposite, "Add...").click();
        DefaultShell fileTypeShell = new DefaultShell("Add File Type");
        new LabeledText((ReferencedComposite)fileTypeShell, "File type:").setText(fileType);
        new OkButton((ReferencedComposite)fileTypeShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)fileTypeShell));
        return this;
    }

    public ExtendedFileEditorsPreferencePage removeFileType(String fileType) {
        this.selectFileType(fileType);
        new PushButton(this.referencedComposite, "Remove").click();
        return this;
    }

    public List<String> getAssociatedEditors() {
        ArrayList<String> resultList = new ArrayList<String>();
        DefaultTable editorsTable = new DefaultTable(this.referencedComposite, 1, new Matcher[0]);
        List editors = editorsTable.getItems();
        for (TableItem editorTableItem : editors) {
            resultList.add(editorTableItem.getText());
        }
        return resultList;
    }

    public List<String> getAssociatedEditorForFileType(String fileType) {
        this.selectFileType(fileType);
        return this.getAssociatedEditors();
    }

    public ExtendedFileEditorsPreferencePage selectAssociatedEditor(String editor) {
        DefaultTable editorsTable = new DefaultTable(this.referencedComposite, 1, new Matcher[0]);
        TableItem item = null;
        try {
            item = editorsTable.getItem(editor);
        }
        catch (CoreLayerException coreLayerException) {
            item = new DefaultTableItem((ReferencedComposite)editorsTable, new Matcher[]{new WithMnemonicTextMatcher((Matcher)new RegexMatcher(String.valueOf(editor) + ".*"))});
        }
        item.select();
        return this;
    }

    public ExtendedFileEditorsPreferencePage makeEditorDefault(String editor) {
        this.selectAssociatedEditor(editor);
        new PushButton(this.referencedComposite, "Default").click();
        return this;
    }

    public ExtendedFileEditorsPreferencePage addAssociatedEditor(String editor) {
        new PushButton(this.referencedComposite, 1, new Matcher[]{new WithMnemonicTextMatcher("Add...")}).click();
        DefaultShell editorShell = new DefaultShell("Editor Selection");
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)editorShell), new String[]{editor}).select();
        new OkButton((ReferencedComposite)editorShell).click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)editorShell));
        return this;
    }

    public ExtendedFileEditorsPreferencePage removeAssociatedEditor(String editor) {
        this.selectAssociatedEditor(editor);
        new PushButton(this.referencedComposite, 1, new Matcher[]{new WithMnemonicTextMatcher("Remove")}).click();
        return this;
    }
}

