/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.wizards.newresource;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.text.LabeledText;

public class BasicNewProjectResourceWizardFirstPage
extends WizardPage {
    private final Logger log = Logger.getLogger(BasicNewProjectResourceWizardFirstPage.class);

    public BasicNewProjectResourceWizardFirstPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public BasicNewProjectResourceWizardFirstPage setProjectName(String projectName) {
        this.log.debug("Set General Project name to '" + projectName + "'");
        new LabeledText(this.referencedComposite, "Project name:").setText(projectName);
        return this;
    }

    public BasicNewProjectResourceWizardFirstPage setProjectLocation(String projectLocation) {
        this.log.debug("Set Project location to '" + projectLocation + "'");
        new CheckBox(this.referencedComposite, "Use default location").toggle(false);
        new LabeledText(this.referencedComposite, "Location:").setText(projectLocation);
        return this;
    }

    public BasicNewProjectResourceWizardFirstPage addProjectToWorkingSet(String workingSet) {
        this.log.debug("Add Project to working set '" + workingSet + "'");
        new CheckBox(this.referencedComposite, "Add project to working sets").toggle(true);
        LabeledCombo cmbWorkingSet = new LabeledCombo(this.referencedComposite, "Working sets:");
        if (!cmbWorkingSet.isEnabled()) {
            throw new EclipseLayerException("Combo box with Working sets is not enabled. Probably no working set is defined");
        }
        cmbWorkingSet.setText(workingSet);
        return this;
    }
}

