/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.Runtime;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardDialog;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.OkButton;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;

public class RuntimePreferencePage
extends PreferencePage {
    public static final String PAGE_NAME = "Runtime Environments";
    public static final String EDIT_BUTTON_NAME = "Edit...";
    private static final Logger log = Logger.getLogger(RuntimePreferencePage.class);

    public RuntimePreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"Server", PAGE_NAME});
    }

    public List<Runtime> getServerRuntimes() {
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        DefaultTable table = new DefaultTable(this.referencedComposite);
        int rows = table.rowCount();
        int i = 0;
        while (i < rows) {
            Runtime runtime = new Runtime();
            runtime.setName(table.getItem(i).getText());
            runtime.setType(table.getItem(i).getText(1));
            runtimes.add(runtime);
            ++i;
        }
        return runtimes;
    }

    public RuntimePreferencePage removeRuntime(Runtime runtime) {
        log.info("Removing runtime '" + runtime + "'");
        this.selectRuntime(runtime.getName());
        new PushButton(this.referencedComposite, "Remove").click();
        new WaitUntil((WaitCondition)new ShellIsAvailable("Server"), TimePeriod.MEDIUM, false);
        if (new ShellIsAvailable("Server").test()) {
            DefaultShell serverShell = new DefaultShell("Server");
            new OkButton((ReferencedComposite)serverShell).click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)serverShell));
        } else {
            log.debug("Server shell was not opened");
        }
        return this;
    }

    public RuntimePreferencePage removeAllRuntimes() {
        log.info("Removing all runtimes");
        for (Runtime runtime : this.getServerRuntimes()) {
            this.removeRuntime(runtime);
        }
        return this;
    }

    private RuntimePreferencePage selectRuntime(String name) {
        DefaultTable table = new DefaultTable(this.referencedComposite);
        log.debug("Selecting runtime '" + name + "'");
        int i = 0;
        while (i < table.rowCount()) {
            String runtimeName = table.getItem(i).getText();
            log.debug("'" + runtimeName + "' was found");
            if (runtimeName.equals(name)) {
                log.debug("'" + runtimeName + "' matched '" + name + "'! Selecting...");
                table.select(new int[]{i});
                return this;
            }
            ++i;
        }
        throw new EclipseLayerException("Unable to find runtime " + name);
    }

    public NewRuntimeWizardDialog addRuntime() {
        log.info("Adding new runtime");
        new PushButton(this.referencedComposite, "Add...").click();
        new DefaultShell("New Server Runtime Environment");
        return new NewRuntimeWizardDialog();
    }

    public RuntimePreferencePage editRuntime(String name) {
        this.selectRuntime(name);
        new PushButton(this.referencedComposite, EDIT_BUTTON_NAME).click();
        return this;
    }
}

