/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.web.ui.wizards;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.group.DefaultGroup;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;

public class DataModelFacetCreationWizardPage
extends WizardPage {
    public DataModelFacetCreationWizardPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public DataModelFacetCreationWizardPage setProjectName(String projectName) {
        new LabeledText(this.referencedComposite, "Project name:").setText(projectName);
        return this;
    }

    public String getProjectName() {
        return new LabeledText(this.referencedComposite, "Project name:").getText();
    }

    public DataModelFacetCreationWizardPage setUseDefaultLocation(boolean useDefaultLocation) {
        new CheckBox((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Project location"), "Use default location").toggle(useDefaultLocation);
        return this;
    }

    public boolean isUseDefaultLocation() {
        return new CheckBox((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Project location"), "Use default location").isChecked();
    }

    public DataModelFacetCreationWizardPage setLocation(String location) {
        new LabeledText(this.referencedComposite, "Location:").setText(location);
        return this;
    }

    public String getLocation() {
        return new LabeledText(this.referencedComposite, "Location:").getText();
    }

    public DataModelFacetCreationWizardPage setTargetRuntime(String targetRuntime) {
        new DefaultCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Target runtime")).setSelection(targetRuntime);
        return this;
    }

    public String getTargetRuntime() {
        return new DefaultCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Target runtime")).getSelection();
    }

    public DataModelFacetCreationWizardPage setConfiguration(String configuration) {
        new DefaultCombo((ReferencedComposite)new DefaultGroup("Configuration")).setSelection(configuration);
        return this;
    }

    public String getConfiguration() {
        return new DefaultCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Configuration")).getSelection();
    }

    public DataModelFacetCreationWizardPage setEARMembership(boolean membership) {
        new CheckBox((ReferencedComposite)new DefaultGroup(this.referencedComposite, "EAR membership"), "Add project to an EAR").toggle(membership);
        return this;
    }

    public boolean isEARMembership() {
        return new CheckBox((ReferencedComposite)new DefaultGroup(this.referencedComposite, "EAR membership"), "Add project to an EAR").isChecked();
    }

    public DataModelFacetCreationWizardPage setEARProjectName(String name) {
        new LabeledCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "EAR membership"), "EAR project name:").setText(name);
        return this;
    }

    public String getEARProjectName() {
        return new LabeledCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "EAR membership"), "EAR project name:").getText();
    }

    public DataModelFacetCreationWizardPage setWorkingSets(boolean workingSets) {
        new CheckBox((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Working sets"), "Add project to working sets").toggle(workingSets);
        return this;
    }

    public DataModelFacetCreationWizardPage setWorkingSets(String workingSets) {
        new LabeledCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Working sets"), "Working sets:").setSelection(workingSets);
        return this;
    }

    public String getWorkingSets() {
        return new LabeledCombo((ReferencedComposite)new DefaultGroup(this.referencedComposite, "Working sets"), "Working sets:").getSelection();
    }

    public DataModelFacetCreationWizardPage activateFacet(String version, String ... facetPath) {
        new PushButton(this.referencedComposite, "Modify...").click();
        DefaultShell facetsShell = new DefaultShell("Project Facets");
        DefaultTreeItem facetTreeItem = new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)facetsShell), facetPath);
        facetTreeItem.select();
        facetTreeItem.setChecked(true);
        if (version != null) {
            new ContextMenuItem(new String[]{"Change Version..."}).select();
            DefaultShell versionShell = new DefaultShell("Change Version");
            new LabeledCombo((ReferencedComposite)versionShell, "Version:").setSelection(version);
            new PushButton((ReferencedComposite)versionShell, "OK").click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)versionShell));
        }
        new PushButton((ReferencedComposite)facetsShell, "OK").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)facetsShell));
        return this;
    }
}

