/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.condition;

import org.eclipse.jface.window.Window;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.AndMatcher;
import org.eclipse.reddeer.common.matcher.MatcherBuilder;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.jface.matcher.WindowMatcher;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;

public class WindowIsAvailable
extends AbstractWaitCondition {
    private Logger logger = Logger.getLogger(WindowIsAvailable.class);
    private AndMatcher matcher;
    private Shell foundShell;

    public WindowIsAvailable(Matcher<?> ... matchers) {
        this(Window.class, matchers);
    }

    public <T extends Window> WindowIsAvailable(Class<T> windowClass, Matcher<?> ... matchers) {
        WindowMatcher wm = new WindowMatcher(windowClass);
        Matcher[] allMatchers = MatcherBuilder.getInstance().addMatcher(matchers, (Matcher)wm);
        this.matcher = new AndMatcher(allMatchers);
    }

    public boolean test() {
        Shell[] availableShells;
        this.logger.debug("Looking for Window matching " + this.matcher);
        Shell[] shellArray = availableShells = ShellLookup.getInstance().getShells();
        int n = availableShells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (this.matcher.matches((Object)shell)) {
                this.foundShell = shell;
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Shell getResult() {
        return this.foundShell;
    }

    public String description() {
        return "window matching " + this.matcher + " is available.";
    }
}

