/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.preference;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.clabel.DefaultCLabel;

public class PreferencePage {
    private final Logger log = Logger.getLogger(PreferencePage.class);
    private String[] path;
    protected ReferencedComposite referencedComposite;

    public PreferencePage(ReferencedComposite referencedComposite, String ... path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null");
        }
        if (path.length == 0) {
            throw new IllegalArgumentException("path can't be empty");
        }
        this.referencedComposite = referencedComposite;
        this.path = path;
    }

    public String getName() {
        DefaultCLabel cl = new DefaultCLabel(this.referencedComposite);
        return cl.getText();
    }

    public String[] getPath() {
        return (String[])this.path.clone();
    }

    public PreferencePage apply() {
        PushButton b = new PushButton(this.referencedComposite, "Apply");
        this.log.info("Apply changes in Preferences dialog");
        b.click();
        return this;
    }

    public PreferencePage restoreDefaults() {
        PushButton b = new PushButton(this.referencedComposite, "Restore Defaults");
        this.log.info("Restore default values in Preferences dialog");
        b.click();
        return this;
    }
}

