/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.jface.window;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.matcher.MatcherBuilder;
import org.eclipse.reddeer.core.handler.WidgetHandler;
import org.eclipse.reddeer.core.lookup.ShellLookup;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.jface.api.Window;
import org.eclipse.reddeer.jface.condition.WindowIsAvailable;
import org.eclipse.reddeer.jface.exception.JFaceLayerException;
import org.eclipse.reddeer.jface.matcher.WindowMatcher;
import org.eclipse.reddeer.jface.window.Openable;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.swt.widgets.Control;
import org.hamcrest.Matcher;

public abstract class AbstractWindow
implements Window {
    protected final Logger log = Logger.getLogger(this.getClass());
    private Shell shell;
    private Matcher<?>[] windowMatchers;

    public AbstractWindow(String text) {
        this(new Matcher[]{new WithTextMatcher(text)});
    }

    public AbstractWindow(Shell shell) {
        if (shell == null) {
            throw new JFaceLayerException("Shell cannot be null");
        }
        this.shell = shell;
    }

    public AbstractWindow() {
    }

    public AbstractWindow(Matcher<?> ... matchers) {
        WindowMatcher wm = new WindowMatcher(this.getEclipseClass());
        Matcher[] allMatchers = MatcherBuilder.getInstance().addMatcher(matchers, (Matcher)wm);
        this.windowMatchers = matchers;
        this.shell = new DefaultShell(ShellLookup.getInstance().getShell(allMatchers));
    }

    @Override
    public Shell getShell() {
        return this.shell;
    }

    @Override
    public void open() {
        if (this.getOpenAction() == null) {
            throw new JFaceLayerException("Unable to open window because open action is not defined");
        }
        if (!this.isOpen()) {
            this.getOpenAction().run();
            this.setShell((Shell)new DefaultShell(this.getOpenAction().getShellMatchers()));
        }
    }

    @Override
    public boolean isOpen() {
        if (this.shell != null) {
            if (!this.shell.isDisposed() && this.shell.isVisible()) {
                this.shell.setFocus();
                return true;
            }
            return false;
        }
        WindowIsAvailable cond = null;
        if (this.getWindowMatchers() != null) {
            cond = new WindowIsAvailable(this.getEclipseClass(), this.getWindowMatchers());
        } else if (this.getOpenAction() != null) {
            cond = new WindowIsAvailable(this.getEclipseClass(), this.getOpenAction().getShellMatchers());
        } else {
            throw new JFaceLayerException("Unable to check if window is open");
        }
        boolean open = cond.test();
        if (open) {
            this.setShell((Shell)new DefaultShell(cond.getResult()));
        }
        return open;
    }

    protected abstract Openable getOpenAction();

    private boolean isWindow(Shell shell) {
        return this.getEclipseClass().isInstance(WidgetHandler.getInstance().getData(shell.getSWTWidget()));
    }

    @Override
    public void setShell(Shell swtShell) {
        this.checkShell(swtShell);
        if (!this.isWindow(swtShell)) {
            String msg = "Provided shell type is '" + this.getShellType(swtShell) + "' and expected is '" + this.getEclipseClass() + "'";
            throw new JFaceLayerException(msg);
        }
        this.shell = swtShell;
    }

    private String getShellType(Shell swtShell) {
        Object shellData = WidgetHandler.getInstance().getData(swtShell.getSWTWidget());
        String shellType = shellData == null ? Shell.class.toString() : shellData.getClass().toString();
        return shellType;
    }

    private void checkShell(Shell shell) {
        if (shell == null) {
            throw new JFaceLayerException("Provided shell is null");
        }
        if (shell.isDisposed()) {
            throw new JFaceLayerException("Provided shell is disposed");
        }
        this.log.trace("Shell " + shell.getText() + " is not null and is not disposed");
    }

    protected void checkShell() {
        if (this.shell == null) {
            throw new JFaceLayerException("Window was not initialized");
        }
        if (this.shell.isDisposed()) {
            throw new JFaceLayerException("Window shell is disposed");
        }
        this.log.trace("Shell " + this.shell.getText() + " is not null and is not disposed");
    }

    @Override
    public Class<? extends org.eclipse.jface.window.Window> getEclipseClass() {
        return org.eclipse.jface.window.Window.class;
    }

    public Matcher<?>[] getWindowMatchers() {
        return this.windowMatchers;
    }

    public Control getControl() {
        if (this.shell.isDisposed()) {
            throw new JFaceLayerException("Window is disposed");
        }
        return (Control)this.shell.getSWTWidget();
    }
}

