/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.execution;

import java.util.LinkedList;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRequirementsRunnerFactory;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.integration.runner.IAfterTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.IBeforeTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequence;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=RedDeerSuite.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedRequirementsRunnerFactory.class)
public class ParameterizedFieldTest {
    private static final String[] PARAMS = new String[]{"param0", "param1"};
    private static final LinkedList<Object> expectedSequence = new LinkedList();
    @Parameterized.Parameter
    public String param;

    static {
        expectedSequence.addLast(TestSequence.createBeforeClass(ParameterizedFieldTest.class));
        expectedSequence.addLast(TestSequence.createIBefore(IBeforeTestImpl.class));
        expectedSequence.addLast(TestSequence.createBefore(ParameterizedFieldTest.class));
        expectedSequence.addLast(TestSequence.createTestWithParam(ParameterizedFieldTest.class, ParameterizedFieldTest.params()[0]));
        expectedSequence.addLast(TestSequence.createAfter(ParameterizedFieldTest.class));
        expectedSequence.addLast(TestSequence.createIAfter(IAfterTestImpl.class));
        expectedSequence.addLast(TestSequence.createIBefore(IBeforeTestImpl.class));
        expectedSequence.addLast(TestSequence.createBefore(ParameterizedFieldTest.class));
        expectedSequence.addLast(TestSequence.createTestWithParam(ParameterizedFieldTest.class, ParameterizedFieldTest.params()[1]));
        expectedSequence.addLast(TestSequence.createAfter(ParameterizedFieldTest.class));
        expectedSequence.addLast(TestSequence.createIAfter(IAfterTestImpl.class));
        expectedSequence.addLast(TestSequence.createAfterClass(ParameterizedFieldTest.class));
    }

    @Parameterized.Parameters(name="{0}")
    public static String[] params() {
        return PARAMS;
    }

    @BeforeClass
    public static void beforeClass() {
        TestSequence.getRealSequence().clear();
        TestSequence.addBeforeClass(ParameterizedFieldTest.class);
    }

    @Before
    public void before() {
        TestSequence.addBefore(ParameterizedFieldTest.class);
    }

    @Test
    public void test() {
        TestSequence.addTestWithParam(ParameterizedFieldTest.class, this.param);
    }

    @After
    public void after() {
        TestSequence.addAfter(ParameterizedFieldTest.class);
    }

    @AfterClass
    public static void afterClass() {
        TestSequence.addAfterClass(ParameterizedFieldTest.class);
        String sequenceDiff = TestSequence.diffRealSequence(expectedSequence);
        TestSequence.getRealSequence().clear();
        Assert.assertTrue((String)("Test sequence is different than expected. " + sequenceDiff), (sequenceDiff == null ? 1 : 0) != 0);
    }
}

