/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.integration.runner.order;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TestSequence {
    private static final String I_BEFORES = "I_BEFORES";
    private static final String I_BEFORES_CLASS = "I_BEFORES_CLASS";
    private static final String I_AFTERS = "I_AFTERS";
    private static final String I_AFTERS_CLASS = "I_AFTERS_CLASS";
    private static final String FULFILL = "FULFILL";
    private static final String CLEANUP = "CLEANUP";
    private static final String DECLARATION = "DECLARATION";
    private static final String BEFORE_CLASS = "BEFORE_CLASS";
    private static final String AFTER_CLASS = "AFTER_CLASS";
    private static final String BEFORE = "BEFORE";
    private static final String AFTER = "AFTER";
    private static final String TEST = "TEST";
    private static final String TEST_WITH_PARAMETER = "TEST_WITH_PARAMETER";
    private static final String CONSTRUCT_TEST = "CONSTRUCT_TEST";
    private static final String CONSTRUCT_TEST_WITH_PARAMETER = "CONSTRUCT_TEST_WITH_PARAMETER";
    private static List<Object> realSequence = new ArrayList<Object>();

    public static List<?> getRealSequence() {
        return realSequence;
    }

    public static void add(Class<?> c) {
        realSequence.add(c);
    }

    public static void addIBefores(Class<?> c) {
        realSequence.add(TestSequence.createIBefore(c));
    }

    public static void addIBeforesClass(Class<?> c) {
        realSequence.add(TestSequence.createIBeforeClass(c));
    }

    public static void addIAfters(Class<?> c) {
        realSequence.add(TestSequence.createIAfter(c));
    }

    public static void addIAftersClass(Class<?> c) {
        realSequence.add(TestSequence.createIAfterClass(c));
    }

    public static void addFulfill(Class<?> c) {
        realSequence.add(TestSequence.createFulfill(c));
    }

    public static void addSetDeclaration(Class<?> c) {
        realSequence.add(TestSequence.createSetDeclaration(c));
    }

    public static void addBeforeClass(Class<?> c) {
        realSequence.add(TestSequence.createBeforeClass(c));
    }

    public static void addAfterClass(Class<?> c) {
        realSequence.add(TestSequence.createAfterClass(c));
    }

    public static void addBefore(Class<?> c) {
        realSequence.add(TestSequence.createBefore(c));
    }

    public static void addAfter(Class<?> c) {
        realSequence.add(TestSequence.createAfter(c));
    }

    public static void addTest(Class<?> c) {
        realSequence.add(TestSequence.createTest(c));
    }

    public static void addTestWithParam(Class<?> c, Object param) {
        realSequence.add(TestSequence.createTestWithParam(c, param));
    }

    public static void addCleanup(Class<?> c) {
        realSequence.add(TestSequence.createCleanup(c));
    }

    public static void addConstructTest(Class<?> c) {
        realSequence.add(TestSequence.constructTest(c));
    }

    public static void addConstructTestWithParam(Class<?> c, Object param) {
        realSequence.add(TestSequence.constructTestWithParam(c, param));
    }

    public static String createIBefore(Class<?> c) {
        return c + " - " + I_BEFORES;
    }

    public static String createIBeforeClass(Class<?> c) {
        return c + " - " + I_BEFORES_CLASS;
    }

    public static String createIAfterClass(Class<?> c) {
        return c + " - " + I_AFTERS_CLASS;
    }

    public static String createIAfter(Class<?> c) {
        return c + " - " + I_AFTERS;
    }

    public static String createFulfill(Class<?> c) {
        return c + " - " + FULFILL;
    }

    public static String createSetDeclaration(Class<?> c) {
        return c + " - " + DECLARATION;
    }

    public static String createBeforeClass(Class<?> c) {
        return c + " - " + BEFORE_CLASS;
    }

    public static String createAfterClass(Class<?> c) {
        return c + " - " + AFTER_CLASS;
    }

    public static String createBefore(Class<?> c) {
        return c + " - " + BEFORE;
    }

    public static String createAfter(Class<?> c) {
        return c + " - " + AFTER;
    }

    public static String createTest(Class<?> c) {
        return c + " - " + TEST;
    }

    public static String createTestWithParam(Class<?> c, Object parameter) {
        return c + " - " + parameter + " - " + TEST_WITH_PARAMETER;
    }

    public static String createCleanup(Class<?> c) {
        return c + " - " + CLEANUP;
    }

    public static String constructTest(Class<?> c) {
        return c + " - " + CONSTRUCT_TEST;
    }

    public static String constructTestWithParam(Class<?> c, Object parameter) {
        return c + " - " + parameter + " - " + CONSTRUCT_TEST_WITH_PARAMETER;
    }

    public static String diffRealSequence(List<?> compareSequence) {
        String result = null;
        if (realSequence != null && compareSequence != null) {
            Object realItem;
            StringBuilder sbDiff = new StringBuilder("Real sequence vs. compared sequence:\n");
            Iterator<Object> itRealSequence = realSequence.iterator();
            Iterator<?> itCompareSequence = compareSequence.iterator();
            int step = 0;
            boolean equals = true;
            while (itRealSequence.hasNext() && itCompareSequence.hasNext()) {
                realItem = itRealSequence.next();
                Object comparedItem = itCompareSequence.next();
                sbDiff.append(step);
                sbDiff.append(". ");
                sbDiff.append(realItem.toString());
                if (realItem.equals(comparedItem)) {
                    sbDiff.append(" == ");
                } else {
                    sbDiff.append(" != ");
                    if (equals) {
                        equals = false;
                    }
                }
                sbDiff.append(comparedItem.toString());
                sbDiff.append("\n");
                ++step;
            }
            while (itRealSequence.hasNext()) {
                realItem = itRealSequence.next();
                sbDiff.append(step);
                sbDiff.append(". ");
                sbDiff.append(realItem.toString());
                sbDiff.append(" != ");
                if (equals) {
                    equals = false;
                }
                sbDiff.append("<null>");
                sbDiff.append("\n");
                ++step;
            }
            while (itCompareSequence.hasNext()) {
                Object compareItem = itCompareSequence.next();
                sbDiff.append(step);
                sbDiff.append(". ");
                sbDiff.append("<null>");
                sbDiff.append(" != ");
                if (equals) {
                    equals = false;
                }
                sbDiff.append(compareItem.toString());
                sbDiff.append("\n");
                ++step;
            }
            if (!equals) {
                result = sbDiff.toString();
            }
        } else {
            result = realSequence != null ? "Compared sequence is null but real sequence is not" : "Real sequence is null but compared sequence is not";
        }
        return result;
    }
}

