/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.requirement.inject;

import java.util.Arrays;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.internal.requirement.inject.RequirementsInjector;
import org.eclipse.reddeer.junit.requirement.inject.RequirementInjectionException;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.ChildRequirementTestMock;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.GrandParentRequirementTestMock;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.NonExistedRequirementTestMock;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.ParentRequirementTestMock;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.RequirementA;
import org.eclipse.reddeer.junit.test.internal.requirement.inject.StaticRequirementTestMock;
import org.eclipse.reddeer.requirements.property.PropertyConfiguration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RequirementsInjectorTest {
    private RequirementsInjector injector = new RequirementsInjector();
    private RequirementA requirementA;
    private Requirements requirements;
    private static final String PROPERTY_NAME = "key";
    private static final String PROPERTY_VALUE = "value";
    private static final String NO_CONFIG = "no-configuration";

    @Before
    public void setupRequirement() {
        PropertyConfiguration propertyConfig = new PropertyConfiguration();
        propertyConfig.addProperty(PROPERTY_NAME, PROPERTY_VALUE);
        this.requirementA = new RequirementA();
        this.requirementA.setConfiguration(propertyConfig);
    }

    @Test
    public void testInjectingToGrandParent() {
        GrandParentRequirementTestMock grandParent = new GrandParentRequirementTestMock();
        this.requirements = new Requirements(Arrays.asList(this.requirementA), GrandParentRequirementTestMock.class, NO_CONFIG);
        this.injector.inject((Object)grandParent, this.requirements);
        Assert.assertTrue((String)"Grand parent's requirementA1 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(grandParent.getRequirementA1().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Grand parent's requirementA2 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(grandParent.getRequirementA2().getConfiguration().getPropertyValue(PROPERTY_NAME)));
    }

    @Test
    public void testInjectingToParent() {
        ParentRequirementTestMock parent = new ParentRequirementTestMock();
        this.requirements = new Requirements(Arrays.asList(this.requirementA), ParentRequirementTestMock.class, NO_CONFIG);
        this.injector.inject((Object)parent, this.requirements);
        Assert.assertTrue((String)"Grand parent's requirementA1 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(parent.getRequirementA1().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Grand parent's requirementA2 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(parent.getRequirementA2().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Parent's requirementA3 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(parent.getRequirementA3().getConfiguration().getPropertyValue(PROPERTY_NAME)));
    }

    @Test
    public void testInjectingToChild() {
        ChildRequirementTestMock child = new ChildRequirementTestMock();
        this.requirements = new Requirements(Arrays.asList(this.requirementA), ChildRequirementTestMock.class, NO_CONFIG);
        this.injector.inject((Object)child, this.requirements);
        Assert.assertTrue((String)"Grand parent's requirementA1 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(child.getRequirementA1().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Grand parent's requirementA2 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(child.getRequirementA2().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Parent's requirementA3 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(child.getRequirementA3().getConfiguration().getPropertyValue(PROPERTY_NAME)));
        Assert.assertTrue((String)"Child's requirementA4 should have injected property, but it does not have it.", (boolean)PROPERTY_VALUE.equals(child.getRequirementA4().getConfiguration().getPropertyValue(PROPERTY_NAME)));
    }

    @Test
    public void testInjectToStatic() {
        this.requirements = new Requirements(Arrays.asList(this.requirementA), StaticRequirementTestMock.class, NO_CONFIG);
        this.injector.inject(StaticRequirementTestMock.class, this.requirements);
        Assert.assertTrue((String)"Requirement is not injected to static field, although it should be.", (boolean)PROPERTY_VALUE.equals(StaticRequirementTestMock.getRequirementA().getConfiguration().getPropertyValue(PROPERTY_NAME)));
    }

    @Test(expected=RequirementInjectionException.class)
    public void testNoRequirementFieldInjection() {
        NonExistedRequirementTestMock testInstance = new NonExistedRequirementTestMock();
        this.requirements = new Requirements(Arrays.asList(this.requirementA), NonExistedRequirementTestMock.class, NO_CONFIG);
        this.injector.inject((Object)testInstance, this.requirements);
    }
}

