/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.runner;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.matcher.VersionMatcher;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.annotation.RequirementRestriction;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.internal.runner.NamedSuite;
import org.eclipse.reddeer.junit.internal.runner.TestsWithoutExecutionSuite;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfigurationPool;
import org.eclipse.reddeer.junit.requirement.matcher.RequirementMatcher;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.internal.requirement.CustomJavaTestRequirement;
import org.eclipse.reddeer.junit.test.internal.requirement.CustomServerTestRequirement;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;

public class RedDeerSuiteTest {
    public static final String REDDEER_SUITE_CONFIG = "resources" + File.separator + "reddeersuitetest-config.json";
    public static final String REDDEER_SUITE_CONFIG2 = "resources" + File.separator + "reddeersuitetest-config2.json";

    @Before
    public void setUp() {
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
        RequirementConfigurationPool.destroyPool();
    }

    @After
    public void tearDown() {
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
    }

    @Test
    public void testSingleTestWithoutConfiguration() throws InitializationError {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        SuiteConfiguration config = new SuiteConfiguration(SimpleTestClass.class);
        List runners = RedDeerSuite.createSuites(SimpleTestClass.class, (SuiteConfiguration)config);
        MatcherAssert.assertThat((Object)runners.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)runners, (Matcher)Matchers.hasItem((Matcher)new NamedSuiteMatcher("no-configuration")));
    }

    @Test
    public void testSimpleSuiteWithoutConfiguration() throws InitializationError {
        SuiteConfiguration config = new SuiteConfiguration(SimpleSuite.class);
        List runners = RedDeerSuite.createSuites(SimpleSuite.class, (SuiteConfiguration)config);
        MatcherAssert.assertThat((Object)runners.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)runners, (Matcher)Matchers.hasItem((Matcher)new NamedSuiteMatcher("no-configuration")));
    }

    @Test
    public void testSimpleSuiteWithMoreTestClassesWithoutConfiguration() throws Throwable {
        Assert.assertEquals((long)2L, (long)this.getTestCount(SimpleSuite2.class));
    }

    @Test
    public void testNestedSuiteWithoutConfiguration() throws Throwable {
        Assert.assertEquals((long)1L, (long)this.getTestCount(ParentSuite.class));
    }

    @Test
    public void testNestedSuiteAndTestClassWithoutConfiguration() throws Throwable {
        Assert.assertEquals((long)2L, (long)this.getTestCount(ParentSuite2.class));
    }

    @Test
    public void testRequirementsSuiteWithConfiguration() throws InitializationError {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        SuiteConfiguration config = new SuiteConfiguration(RequirementSuite.class);
        List runners = RedDeerSuite.createSuites(RequirementSuite.class, (SuiteConfiguration)config);
        String java7config = "java-1.7";
        String tomcat2 = "server-tomcat2";
        MatcherAssert.assertThat((Object)runners.size(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)runners, (Matcher)Matchers.hasItem((Matcher)new NamedSuiteMatcher(java7config)));
        MatcherAssert.assertThat((Object)runners, (Matcher)Matchers.hasItem((Matcher)new NamedSuiteMatcher(tomcat2)));
        MatcherAssert.assertThat((Object)runners, (Matcher)Matchers.hasItem((Matcher)new NamedSuiteMatcher("no-configuration")));
    }

    @Test
    public void testJavaServerTestWithConfiguration() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)6L, (long)this.getTestCount(JavaServerTestClass.class));
    }

    @Test
    public void testJavaServerTestWithRestrictedConfiguration() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)2L, (long)this.getTestCount(RestrictedJavaTestClass.class));
    }

    @Test
    public void testJavaServerTestWithRestrictedConfiguration2() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)2L, (long)this.getTestCount(RestrictedJavaTestClass2.class));
    }

    @Test
    public void testJavaServerTestWithRestrictedConfigurationCollection() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)2L, (long)this.getTestCount(RestrictedJavaTestClassWithCollection.class));
    }

    @Test
    public void testJavaServerTestWithRestrictedConfigurationCollectionAndMatcher() throws Throwable {
        try {
            new SuiteConfiguration(RestrictedJavaTestClassWithCollectionAndMatcher.class);
        }
        catch (RedDeerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("More than one method is annotated with"));
        }
    }

    @Test
    public void testIncorrectRestriction() throws Throwable {
        try {
            new SuiteConfiguration(IncorrectRestriction.class);
        }
        catch (RedDeerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("does not have specified return type"));
        }
    }

    @Test
    public void testIncorrectRestriction2() throws Throwable {
        try {
            new SuiteConfiguration(RestrictedJavaTestClassWithCollectionTwoRequirementsIncorrect.class);
        }
        catch (RedDeerException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("More than one matcher is defined for the"));
        }
    }

    @Test
    public void testRestrictedConfigurationTwoRequirements() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)2L, (long)this.getTestCount(RestrictedJavaTestClassWithCollectionTwoRequirements.class));
    }

    @Test
    public void testRestrictedConfigurationTwoRequirements2() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)4L, (long)this.getTestCount(RestrictedJavaTestClassWithCollectionTwoRequirements2.class));
    }

    @Test
    public void testRestrictedConfigurationTwoRequirements3() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG);
        Assert.assertEquals((long)6L, (long)this.getTestCount(RestrictedJavaTestClassWithCollectionTwoRequirements3.class));
    }

    @Test
    public void testJavaServerTestWithPartialConfiguration() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG2);
        Assert.assertEquals((long)0L, (long)this.getTestCount(JavaServerTestClass.class));
    }

    @Test
    public void testRequirementsSuite_withPartialConfig() throws Throwable {
        System.setProperty(RedDeerProperties.CONFIG_FILE.getName(), REDDEER_SUITE_CONFIG2);
        Assert.assertEquals((long)4L, (long)this.getTestCount(RequirementSuite.class));
    }

    private int getTestCount(Class suiteClass) throws Throwable {
        SuiteConfiguration config = new SuiteConfiguration(suiteClass);
        List runners = RedDeerSuite.createSuites((Class)suiteClass, (SuiteConfiguration)config);
        int testCount = 0;
        for (Runner runner : runners) {
            if (runner instanceof TestsWithoutExecutionSuite) continue;
            testCount = (short)(testCount + runner.getDescription().testCount());
        }
        return testCount;
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class IncorrectRestriction {
        @RequirementRestriction
        public static Integer getRestrictionMatcher() {
            return 1;
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    @CustomServerTestRequirement.CustomServerAnnotation
    public static class JavaServerTestClass {
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class JavaTestClass {
    }

    class NamedSuiteMatcher
    extends TypeSafeMatcher<Runner> {
        private String name;

        public NamedSuiteMatcher(String name) {
            this.name = name;
        }

        public void describeTo(Description description) {
        }

        public boolean matchesSafely(Runner item) {
            return item instanceof NamedSuite && ((NamedSuite)item).getName().contains(this.name);
        }
    }

    @Suite.SuiteClasses(value={SimpleSuite.class})
    public static class ParentSuite {
    }

    @Suite.SuiteClasses(value={SimpleSuite.class, SimpleTestClass.class})
    public static class ParentSuite2 {
    }

    @Suite.SuiteClasses(value={JavaTestClass.class, ServerTestClass.class, SimpleTestClass.class})
    public static class RequirementSuite {
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class RestrictedJavaTestClass {
        @RequirementRestriction
        public static RequirementMatcher getRestrictionMatcher() {
            return new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher(">1.7"));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class RestrictedJavaTestClass2 {
        @RequirementRestriction
        public static RequirementMatcher getRestrictionMatcher() {
            return new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]"));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class RestrictedJavaTestClassWithCollection {
        @RequirementRestriction
        public static Collection<RequirementMatcher> getRestrictionMatcher() {
            return Arrays.asList(new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]")));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    public static class RestrictedJavaTestClassWithCollectionAndMatcher {
        @RequirementRestriction
        public static Collection<RequirementMatcher> getRestrictionMatchers() {
            return Arrays.asList(new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]")));
        }

        @RequirementRestriction
        public static RequirementMatcher getRestrictionMatcher() {
            return new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]"));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    @CustomServerTestRequirement.CustomServerAnnotation
    public static class RestrictedJavaTestClassWithCollectionTwoRequirements {
        @RequirementRestriction
        public static Collection<RequirementMatcher> CustomJavaAnnotation() {
            return Arrays.asList(new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]")), new RequirementMatcher(CustomServerTestRequirement.CustomServerAnnotation.class, "version", (Matcher)new VersionMatcher(">2.0")));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    @CustomServerTestRequirement.CustomServerAnnotation
    public static class RestrictedJavaTestClassWithCollectionTwoRequirements2 {
        @RequirementRestriction
        public static Collection<RequirementMatcher> getRestrictionMatcher() {
            return Arrays.asList(new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]")));
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    @CustomServerTestRequirement.CustomServerAnnotation
    public static class RestrictedJavaTestClassWithCollectionTwoRequirements3 {
        @RequirementRestriction
        public static Collection<RequirementMatcher> getRestrictionMatcher() {
            return new ArrayList<RequirementMatcher>();
        }
    }

    @CustomJavaTestRequirement.CustomJavaAnnotation
    @CustomServerTestRequirement.CustomServerAnnotation
    public static class RestrictedJavaTestClassWithCollectionTwoRequirementsIncorrect {
        @RequirementRestriction
        public static Collection<RequirementMatcher> getRestrictionMatcher() {
            return Arrays.asList(new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "version", (Matcher)new VersionMatcher("[1.8;1.9]")), new RequirementMatcher(CustomJavaTestRequirement.CustomJavaAnnotation.class, "name", (Matcher)new RegexMatcher("name.*")));
        }
    }

    @CustomServerTestRequirement.CustomServerAnnotation
    public static class ServerTestClass {
    }

    @Suite.SuiteClasses(value={SimpleTestClass.class})
    public static class SimpleSuite {
    }

    @Suite.SuiteClasses(value={SimpleTestClass.class, SimpleTestClass2.class})
    public static class SimpleSuite2 {
    }

    public static class SimpleTestClass {
    }

    public static class SimpleTestClass2 {
    }
}

