/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.requirement;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.junit.execution.PriorityComparator;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;

public class Requirements
implements Requirement<Annotation>,
Iterable<Requirement<?>> {
    private List<Requirement<?>> requirements;
    private Class<?> clazz;
    private String configID;
    private Logger log = Logger.getLogger(Requirements.class);

    public Requirements(List<Requirement<?>> requirements, Class<?> clazz, String configID) {
        if (requirements == null) {
            throw new IllegalArgumentException("The requirements list was null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("The class containing requirements is null");
        }
        requirements.sort(new PriorityComparator());
        this.requirements = requirements;
        this.clazz = clazz;
        this.configID = configID;
    }

    @Override
    public Iterator<Requirement<?>> iterator() {
        return this.requirements.iterator();
    }

    public int size() {
        return this.requirements.size();
    }

    @Override
    public void fulfill() {
        for (Requirement<?> r : this.requirements) {
            try {
                this.log.info("Fulfilling requirement of " + r.getClass());
                r.fulfill();
            }
            catch (Throwable ex) {
                this.handleException(ex, r);
                throw ex;
            }
        }
    }

    @Override
    public void setDeclaration(Annotation declaration) {
        throw new IllegalStateException("This method should never be called on wrapper object");
    }

    @Override
    public void cleanUp() {
        for (Requirement<?> r : this.requirements) {
            try {
                this.log.info("Cleaning up requirement of " + r.getClass());
                r.cleanUp();
            }
            catch (Throwable ex) {
                this.handleException(ex, r);
                throw ex;
            }
        }
    }

    private void handleException(Throwable ex, Requirement<?> r) {
        if (ScreenshotCapturer.shouldCaptureScreenshotOnException(ex)) {
            ScreenshotCapturer screenshotCapturer = ScreenshotCapturer.getInstance();
            try {
                screenshotCapturer.captureScreenshotOnFailure(this.configID, ScreenshotCapturer.getScreenshotFileName(this.clazz, null, r.getClass().getSimpleName()));
            }
            catch (CaptureScreenshotException e) {
                e.printInfo(this.log);
            }
        }
    }

    @Override
    public Annotation getDeclaration() {
        throw new IllegalStateException("This method should never be called on wrapper object");
    }
}

