/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunAfters
extends AbstractStatementWithScreenshot {
    private final List<FrameworkMethod> fAfters;

    public RunAfters(String config, Statement next, TestClass testClass, List<FrameworkMethod> afters) {
        this(config, next, testClass, null, null, afters);
    }

    public RunAfters(String config, Statement next, TestClass testClass, FrameworkMethod method, Object target, List<FrameworkMethod> afters) {
        super(config, next, testClass, method, target);
        this.fAfters = afters;
    }

    public void evaluate() throws Throwable {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            this.nextStatement.evaluate();
        }
        catch (Throwable e) {
            errors.add(e);
        }
        for (FrameworkMethod each : this.fAfters) {
            try {
                this.frameworkMethod = each;
                this.frameworkMethod.invokeExplosively(this.target, new Object[0]);
            }
            catch (Throwable e) {
                if (ScreenshotCapturer.shouldCaptureScreenshotOnException(e)) {
                    if (this.isClassLevel()) {
                        this.createScreenshot("AfterClass");
                    } else {
                        this.createScreenshot("After");
                    }
                }
                errors.add(e);
            }
        }
        MultipleFailureException.assertEmpty(errors);
    }
}

