/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner.statement;

import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.junit.internal.runner.statement.AbstractStatementWithScreenshot;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class RunBefores
extends AbstractStatementWithScreenshot {
    private final List<FrameworkMethod> befores;

    public RunBefores(String config, Statement next, TestClass testClass, List<FrameworkMethod> befores) {
        this(config, next, testClass, null, null, befores);
    }

    public RunBefores(String config, Statement next, TestClass testClass, FrameworkMethod method, Object target, List<FrameworkMethod> befores) {
        super(config, next, testClass, method, target);
        this.befores = befores;
    }

    public void evaluate() throws Throwable {
        FrameworkMethod before = null;
        try {
            Iterator<FrameworkMethod> iterator = this.befores.iterator();
            while (iterator.hasNext()) {
                FrameworkMethod bfr;
                before = bfr = iterator.next();
                before.invokeExplosively(this.target, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            if (ScreenshotCapturer.shouldCaptureScreenshotOnException(throwable)) {
                if (this.isClassLevel()) {
                    this.frameworkMethod = before;
                    this.createScreenshot("BeforeClass");
                } else {
                    this.createScreenshot("Before_" + before.getName());
                }
            }
            throw throwable;
        }
        this.nextStatement.evaluate();
    }
}

