/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.autobuilding;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.junit.requirement.Requirement;

public class AutoBuildingRequirement
implements Requirement<AutoBuilding> {
    private AutoBuilding autoBuilding;
    private boolean autoBuildingOriginalValue;

    public void fulfill() {
        this.autoBuildingOriginalValue = PreferencesUtil.isAutoBuildingOn();
        if (this.autoBuilding.value()) {
            PreferencesUtil.setAutoBuildingOn();
        } else {
            PreferencesUtil.setAutoBuildingOff();
        }
    }

    public void setDeclaration(AutoBuilding autoBuilding) {
        this.autoBuilding = autoBuilding;
    }

    public void cleanUp() {
        if (!this.autoBuilding.cleanup()) {
            return;
        }
        if (this.autoBuildingOriginalValue) {
            PreferencesUtil.setAutoBuildingOn();
        } else {
            PreferencesUtil.setAutoBuildingOff();
        }
    }

    public AutoBuilding getDeclaration() {
        return this.autoBuilding;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface AutoBuilding {
        public boolean value() default true;

        public boolean cleanup() default true;
    }
}

