/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.jre;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.debug.ui.jres.JREsPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.requirements.jre.JREConfiguration;
import org.eclipse.reddeer.requirements.property.RequirementPropertyExpandor;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;

public class JRERequirement
implements ConfigurableRequirement<JREConfiguration, JRE> {
    private Logger log = Logger.getLogger(JRERequirement.class);
    private JRE jre;
    private JREConfiguration configuration;

    public void fulfill() {
        this.log.info("JRE Requirement fulfill performed");
        this.log.debug("Configuration (name,version,path): %s, %s, %s", new Object[]{this.configuration.getName(), this.configuration.getVersion(), this.configuration.getPath()});
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)page);
        page.addJRE(this.getPath(), this.configuration.getName());
        dialog.ok();
    }

    public void setDeclaration(JRE declaration) {
        this.jre = declaration;
    }

    public void cleanUp() {
        if (this.jre.cleanup()) {
            WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
            dialog.open();
            JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
            dialog.select((PreferencePage)page);
            page.deleteJRE(this.configuration.getName());
            dialog.ok();
        }
    }

    public Class<JREConfiguration> getConfigurationClass() {
        return JREConfiguration.class;
    }

    public void setConfiguration(JREConfiguration config) {
        this.configuration = config;
    }

    public JRE getDeclaration() {
        return this.jre;
    }

    public String getPath() {
        return RequirementPropertyExpandor.getProperty(this.configuration.getPath());
    }

    public JREConfiguration getConfiguration() {
        return this.configuration;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface JRE {
        public boolean cleanup() default false;
    }
}

