/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.server.apache.tomcat;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizard;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizardPage;
import org.eclipse.reddeer.junit.requirement.ConfigurableRequirement;
import org.eclipse.reddeer.requirements.property.RequirementPropertyExpandor;
import org.eclipse.reddeer.requirements.server.AbstractServerRequirement;
import org.eclipse.reddeer.requirements.server.ConfiguredServerInfo;
import org.eclipse.reddeer.requirements.server.ServerRequirementState;
import org.eclipse.reddeer.requirements.server.apache.tomcat.ApacheTomcatServerConfiguration;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.hamcrest.Matcher;

public class ApacheTomcatServerRequirement
extends AbstractServerRequirement
implements ConfigurableRequirement<ApacheTomcatServerConfiguration, ApacheTomcatServer> {
    private static final Logger LOGGER = Logger.getLogger(ApacheTomcatServerRequirement.class);
    private ApacheTomcatServerConfiguration config;
    private static ConfiguredServerInfo lastServerConfiguration;
    private ApacheTomcatServer server;

    public void fulfill() {
        if (lastServerConfiguration == null || !this.isLastConfiguredServerPresent()) {
            LOGGER.info("Setup Apache Tomcat server");
            this.setupServerAdapter();
            lastServerConfiguration = new ConfiguredServerInfo(this.getServerNameLabelText(), this.getRuntimeNameLabelText(), this.config);
        }
        this.setupServerState(this.server.state());
    }

    @Override
    public String getServerNameLabelText() {
        return "Apache Tomcat v" + this.config.getVersion() + " Server at localhost";
    }

    @Override
    public String getRuntimeNameLabelText() {
        return "Apache Tomcat v" + this.config.getVersion() + " Runtime";
    }

    private void setupServerAdapter() {
        NewServerWizard swd = new NewServerWizard();
        swd.open();
        NewServerWizardPage swpage = new NewServerWizardPage((ReferencedComposite)swd);
        swpage.selectType(new String[]{"Apache", "Tomcat v" + this.config.getVersion() + " Server"});
        swpage.setName(this.getServerNameLabelText());
        swd.next();
        new DefaultText(0, new Matcher[0]).setText(this.getRuntimeNameLabelText());
        new DefaultText(1, new Matcher[0]).setText(this.getRuntime());
        swd.finish();
    }

    public String getRuntime() {
        return RequirementPropertyExpandor.getProperty(this.config.getRuntime());
    }

    public void setDeclaration(ApacheTomcatServer server) {
        this.server = server;
    }

    public Class<ApacheTomcatServerConfiguration> getConfigurationClass() {
        return ApacheTomcatServerConfiguration.class;
    }

    public void setConfiguration(ApacheTomcatServerConfiguration config) {
        this.config = config;
    }

    public void cleanUp() {
        if (this.server.cleanup() && this.config != null) {
            this.removeServerAndRuntime(lastServerConfiguration);
            lastServerConfiguration = null;
        }
    }

    @Override
    public ConfiguredServerInfo getConfiguredConfig() {
        return lastServerConfiguration;
    }

    public ApacheTomcatServer getDeclaration() {
        return this.server;
    }

    @Override
    public ApacheTomcatServerConfiguration getConfiguration() {
        return this.config;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ApacheTomcatServer {
        public ServerRequirementState state() default ServerRequirementState.RUNNING;

        public boolean cleanup() default true;
    }
}

