/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.wizard;

import java.util.logging.Logger;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.selectionwizard.NewMenuWizard;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public abstract class RedDeerWizardTestCase {
    private static final Logger LOG = Logger.getLogger(RedDeerWizardTestCase.class.getName());
    protected static NewMenuWizard wizard;
    protected static String projectName;

    @Before
    public void open() {
        wizard.open();
    }

    @After
    public void close() {
        try {
            new DefaultShell(this.getWizardText());
            wizard.cancel();
        }
        catch (CoreLayerException coreLayerException) {
            LOG.info("Shell " + this.getWizardText() + " is not open");
        }
    }

    @AfterClass
    public static void deleteProject() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)pe.getProject(projectName), (boolean)true);
    }

    abstract String getWizardText();
}

