/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.reddeer.eclipse.core.RemotePluginTestRunner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public class UITestApplication
implements IApplication,
ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private TestableObject fTestableObject;
    private IApplication fApplication;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        Object app = this.getApplication(args);
        Assert.isNotNull((Object)app, (String)("The application " + this.getApplicationToRun(args) + " could not be found."));
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        if (app instanceof IApplication) {
            this.fApplication = (IApplication)app;
            return this.fApplication.start(context);
        }
        throw new IllegalArgumentException("Could not execute application " + this.getApplicationToRun(args));
    }

    public void stop() {
        if (this.fApplication != null) {
            this.fApplication.stop();
        }
    }

    private Object getApplication(String[] args) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        String applicationToRun = this.getApplicationToRun(args);
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", applicationToRun);
        Assert.isNotNull((Object)extension, (String)("Could not find IExtension for application: " + applicationToRun));
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
            return runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            return product.getApplication();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return DEFAULT_APP_3_0;
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        RemotePluginTestRunner.main(Platform.getCommandLineArgs());
        this.fTestableObject.testingFinished();
    }
}

