/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    int modelHandle;
    int checkRenderer;
    int columnCount;
    int sortDirection;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    int ignoreCell;
    TreeItem[] items;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkColor drawForeground;
    GdkRGBA background;
    GdkRGBA foreground;
    GdkRGBA drawForegroundRGBA;
    boolean ownerDraw;
    boolean ignoreSize;
    boolean ignoreAccessibility;
    boolean pixbufSizeSet;
    boolean hasChildren;
    int pixbufHeight;
    int pixbufWidth;
    TreeItem topItem;
    double cachedAdjustment;
    double currentAdjustment;
    Color headerBackground;
    Color headerForeground;
    String headerCSSBackground;
    String headerCSSForeground;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_TYPES = 5;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        if (!this.ownerDraw) {
            switch (eventType) {
                case 40: 
                case 41: 
                case 42: {
                    this.ownerDraw = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(int iter) {
        int id = this.getId(iter, true);
        if (this.items[id] != null) {
            return this.items[id];
        }
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        int depth = GTK.gtk_tree_path_get_depth(path);
        int[] indices = new int[depth];
        C.memmove(indices, GTK.gtk_tree_path_get_indices(path), 4 * depth);
        int parentIter = 0;
        if (depth > 1) {
            GTK.gtk_tree_path_up(path);
            parentIter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter(this.modelHandle, parentIter, path);
        }
        this.items[id] = new TreeItem(this, parentIter, 0, indices[indices.length - 1], false);
        GTK.gtk_tree_path_free(path);
        if (parentIter != 0) {
            OS.g_free(parentIter);
        }
        return this.items[id];
    }

    TreeItem _getItem(int parentIter, int index) {
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, index);
        int id = this.getId(iter, true);
        OS.g_free(iter);
        if (this.items[id] != null) {
            return this.items[id];
        }
        this.items[id] = new TreeItem(this, parentIter, 0, index, false);
        return this.items[id];
    }

    int getId(int iter, boolean queryModel) {
        if (queryModel) {
            int[] value = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                return value[0];
            }
        }
        int id = 0;
        while (id < this.items.length && this.items[id] != null) {
            ++id;
        }
        if (id == this.items.length) {
            TreeItem[] newItems = new TreeItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        GTK.gtk_tree_store_set(this.modelHandle, iter, 0, id, -1);
        return id;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    int cellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        if (cell == this.ignoreCell) {
            return 0;
        }
        TreeItem item = this._getItem(iter);
        if (item != null) {
            OS.g_object_set_qdata(cell, Display.SWT_OBJECT_INDEX2, item.handle);
        }
        boolean isPixbuf = GTK.GTK_IS_CELL_RENDERER_PIXBUF(cell);
        boolean isText = GTK.GTK_IS_CELL_RENDERER_TEXT(cell);
        if (isText && GTK.GTK3) {
            GTK.gtk_cell_renderer_set_fixed_size(cell, -1, -1);
        }
        if (!isPixbuf && !isText) {
            return 0;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 6;
            customDraw = this.firstCustomDraw;
        } else {
            TreeColumn column = (TreeColumn)this.display.getWidget(tree_column);
            if (column != null) {
                modelIndex = column.modelIndex;
                customDraw = column.customDraw;
            }
        }
        if (modelIndex == -1) {
            return 0;
        }
        boolean setData = false;
        boolean updated = false;
        if ((this.style & 0x10000000) != 0) {
            if (!item.cached) {
                setData = this.checkData(item);
            }
            if (item.updated) {
                updated = true;
                item.updated = false;
            }
        }
        int[] ptr = new int[1];
        if (setData) {
            if (isPixbuf) {
                ptr[0] = 0;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 0, ptr, -1);
                OS.g_object_set(cell, GTK.GTK3 ? OS.gicon : OS.pixbuf, ptr[0], 0);
                if (ptr[0] != 0) {
                    OS.g_object_unref(ptr[0]);
                }
            } else {
                ptr[0] = 0;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 1, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.text, ptr[0], 0);
                    OS.g_free(ptr[0]);
                }
            }
        }
        if (customDraw) {
            if (!this.ownerDraw) {
                ptr[0] = 0;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 3, ptr, -1);
                if (ptr[0] != 0) {
                    if (GTK.GTK3) {
                        OS.g_object_set(cell, OS.cell_background_rgba, ptr[0], 0);
                        GDK.gdk_rgba_free(ptr[0]);
                    } else {
                        OS.g_object_set(cell, OS.cell_background_gdk, ptr[0], 0);
                        GDK.gdk_color_free(ptr[0]);
                    }
                }
            }
            if (!isPixbuf) {
                ptr[0] = 0;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 2, ptr, -1);
                if (ptr[0] != 0) {
                    if (GTK.GTK3) {
                        OS.g_object_set(cell, OS.foreground_rgba, ptr[0], 0);
                        GDK.gdk_rgba_free(ptr[0]);
                    } else {
                        OS.g_object_set(cell, OS.foreground_gdk, ptr[0], 0);
                        GDK.gdk_color_free(ptr[0]);
                    }
                }
                ptr[0] = 0;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 4, ptr, -1);
                if (ptr[0] != 0) {
                    OS.g_object_set(cell, OS.font_desc, ptr[0], 0);
                    OS.pango_font_description_free(ptr[0]);
                }
            }
        }
        if (setData || updated) {
            this.ignoreCell = cell;
            this.setScrollWidth(tree_column, item);
            this.ignoreCell = 0;
        }
        return 0;
    }

    boolean checkData(TreeItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            TreeItem parentItem = item.getParentItem();
            Event event = new Event();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            int mask = 17;
            int signal_id = OS.g_signal_lookup(OS.row_changed, GTK.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, mask, signal_id, 0, 0, 0, this.handle);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, mask, signal_id, 0, 0, 0, this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(int column, int iter, boolean recurse) {
        GTK.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int width = 0;
        int[] w = new int[1];
        int path = 0;
        int expander_column = GTK.gtk_tree_view_get_expander_column(this.handle);
        if (expander_column == 0 && !GTK.gtk_tree_view_column_get_visible(column)) {
            GTK.gtk_tree_view_column_set_visible(column, true);
            expander_column = GTK.gtk_tree_view_get_expander_column(this.handle);
            GTK.gtk_tree_view_column_set_visible(column, false);
        }
        if (expander_column == column) {
            GdkRectangle rect = new GdkRectangle();
            GTK.gtk_widget_realize(this.handle);
            path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_get_cell_area(this.handle, path, column, rect);
            width += rect.x;
            if (!GTK.gtk_tree_view_column_get_visible(column)) {
                GTK.gtk_widget_style_get(this.handle, OS.expander_size, w, 0);
                width += w[0] + 4;
            }
        }
        GTK.gtk_widget_style_get(this.handle, OS.focus_line_width, w, 0);
        width += 2 * w[0];
        int list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0) {
            return 0;
        }
        int temp = list;
        while (temp != 0) {
            int renderer = OS.g_list_data(temp);
            if (renderer != 0) {
                this.gtk_cell_renderer_get_preferred_size(renderer, this.handle, w, null);
                width += w[0];
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (recurse) {
            boolean expanded;
            if (path == 0) {
                path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            }
            if (expanded = GTK.gtk_tree_view_row_expanded(this.handle, path)) {
                int childIter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, childIter, iter);
                while (valid) {
                    width = Math.max(width, this.calculateWidth(column, childIter, true));
                    valid = GTK.gtk_tree_model_iter_next(this.modelHandle, childIter);
                }
                OS.g_free(childIter);
            }
        }
        if (path != 0) {
            GTK.gtk_tree_path_free(path);
        }
        if (GTK.gtk_tree_view_get_grid_lines(this.handle) > 0) {
            GTK.gtk_widget_style_get(this.handle, OS.grid_line_width, w, 0);
            width += 2 * w[0];
        }
        return width;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.clear(0, index, all);
    }

    void clear(int parentIter, int index, boolean all) {
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, index);
        int[] value = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
        if (value[0] != -1) {
            TreeItem item = this.items[value[0]];
            item.clear();
        }
        if (all) {
            this.clearAll(all, iter);
        }
        OS.g_free(iter);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(all, 0);
    }

    void clearAll(boolean all, int parentIter) {
        int length = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (length == 0) {
            return;
        }
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        int[] value = new int[1];
        while (valid) {
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                TreeItem item = this.items[value[0]];
                item.clear();
            }
            if (all) {
                this.clearAll(all, iter);
            }
            valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        GTK.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (size.x == 0 && wHint == -1) {
            size.x = 64;
        }
        if (GTK.GTK3 && hHint == -1 && size.y == this.getHeaderHeight()) {
            size.y = this.getItemCount() * this.getItemHeightInPixels() + this.getHeaderHeight();
        }
        if (size.y == 0 && hHint == -1) {
            size.y = 64;
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, size.x, size.y);
        size.x = trim.width;
        size.y = trim.height;
        return size;
    }

    void copyModel(int oldModel, int oldStart, int newModel, int newStart, int[] types, int oldParent, int newParent, int modelLength) {
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_iter_children(oldModel, iter, oldParent)) {
            int[] oldItems = new int[GTK.gtk_tree_model_iter_n_children(oldModel, oldParent)];
            int oldIndex = 0;
            int[] ptr = new int[1];
            int[] ptr1 = new int[1];
            do {
                int newItem;
                if ((newItem = OS.g_malloc(GTK.GtkTreeIter_sizeof())) == 0) {
                    this.error(2);
                }
                GTK.gtk_tree_store_append(newModel, newItem, newParent);
                GTK.gtk_tree_model_get(oldModel, iter, 0, ptr1, -1);
                int index = ptr1[0];
                TreeItem item = null;
                if (index != -1) {
                    item = this.items[index];
                    if (item != null) {
                        int oldItem = item.handle;
                        oldItems[oldIndex++] = oldItem;
                        int j = 0;
                        while (j < 3) {
                            GTK.gtk_tree_model_get(oldModel, oldItem, j, ptr1, -1);
                            GTK.gtk_tree_store_set(newModel, newItem, j, ptr1[0], -1);
                            ++j;
                        }
                        j = 3;
                        while (j < 6) {
                            GTK.gtk_tree_model_get(oldModel, oldItem, j, ptr, -1);
                            GTK.gtk_tree_store_set(newModel, newItem, j, ptr[0], -1);
                            if (ptr[0] != 0) {
                                if (GTK.GTK3) {
                                    if (types[j] == GDK.GDK_TYPE_RGBA()) {
                                        GDK.gdk_rgba_free(ptr[0]);
                                    }
                                } else if (types[j] == GDK.GDK_TYPE_COLOR()) {
                                    GDK.gdk_color_free(ptr[0]);
                                }
                                if (types[j] == OS.G_TYPE_STRING()) {
                                    OS.g_free(ptr[0]);
                                } else if (types[j] == GDK.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(ptr[0]);
                                } else if (types[j] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(ptr[0]);
                                }
                            }
                            ++j;
                        }
                        j = 0;
                        while (j < modelLength - 6) {
                            int newIndex = newStart + j;
                            GTK.gtk_tree_model_get(oldModel, oldItem, oldStart + j, ptr, -1);
                            GTK.gtk_tree_store_set(newModel, newItem, newIndex, ptr[0], -1);
                            if (ptr[0] != 0) {
                                if (GTK.GTK3) {
                                    if (types[newIndex] == GDK.GDK_TYPE_RGBA()) {
                                        GDK.gdk_rgba_free(ptr[0]);
                                    }
                                } else if (types[newIndex] == GDK.GDK_TYPE_COLOR()) {
                                    GDK.gdk_color_free(ptr[0]);
                                }
                                if (types[newIndex] == OS.G_TYPE_STRING()) {
                                    OS.g_free(ptr[0]);
                                } else if (types[newIndex] == GDK.GDK_TYPE_PIXBUF()) {
                                    OS.g_object_unref(ptr[0]);
                                } else if (types[newIndex] == OS.PANGO_TYPE_FONT_DESCRIPTION()) {
                                    OS.pango_font_description_free(ptr[0]);
                                }
                            }
                            ++j;
                        }
                    }
                } else {
                    GTK.gtk_tree_store_set(newModel, newItem, 0, -1, -1);
                }
                this.copyModel(oldModel, oldStart, newModel, newStart, types, iter, newItem, modelLength);
                if (item != null) {
                    item.handle = newItem;
                    continue;
                }
                OS.g_free(newItem);
            } while (GTK.gtk_tree_model_iter_next(oldModel, iter));
            int i = 0;
            while (i < oldItems.length) {
                int oldItem = oldItems[i];
                if (oldItem != 0) {
                    GTK.gtk_tree_store_remove(oldModel, oldItem);
                    OS.g_free(oldItem);
                }
                ++i;
            }
        }
        OS.g_free(iter);
    }

    void createColumn(TreeColumn column, int index) {
        int columnHandle;
        int modelIndex = 6;
        if (this.columnCount != 0) {
            int modelLength = GTK.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            int i = 0;
            while (i < this.columnCount) {
                int columnIndex = this.columns[i].modelIndex;
                int j = 0;
                while (j < 5) {
                    usedColumns[columnIndex + j] = true;
                    ++j;
                }
                ++i;
            }
            while (modelIndex < modelLength) {
                if (!usedColumns[modelIndex]) break;
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                int oldModel = this.modelHandle;
                int[] types = this.getColumnTypes(this.columnCount + 4);
                int newModel = GTK.gtk_tree_store_newv(types.length, types);
                if (newModel == 0) {
                    this.error(2);
                }
                this.copyModel(oldModel, 6, newModel, 6, types, 0, 0, modelLength);
                GTK.gtk_tree_view_set_model(this.handle, newModel);
                this.setModel(newModel);
            }
        }
        if ((columnHandle = GTK.gtk_tree_view_column_new()) == 0) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TreeColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            GTK.gtk_tree_view_column_set_sizing(columnHandle, 0);
        } else {
            GTK.gtk_tree_view_column_set_sizing(columnHandle, 2);
        }
        GTK.gtk_tree_view_column_set_resizable(columnHandle, true);
        GTK.gtk_tree_view_column_set_clickable(columnHandle, true);
        GTK.gtk_tree_view_column_set_min_width(columnHandle, 0);
        GTK.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (this.columnCount != 0) {
            GTK.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        GTK.gtk_widget_set_has_window(this.fixedHandle, true);
        this.scrolledHandle = GTK.gtk_scrolled_window_new(0, 0);
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        int[] types = this.getColumnTypes(1);
        this.modelHandle = GTK.gtk_tree_store_newv(types.length, types);
        if (this.modelHandle == 0) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        GTK.gtk_container_add(this.fixedHandle, this.scrolledHandle);
        GTK.gtk_container_add(this.scrolledHandle, this.handle);
        int mode = (this.style & 2) != 0 ? 3 : 2;
        int selectionHandle = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(selectionHandle, mode);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            GTK.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0);
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void createItem(TreeColumn column, int index) {
        int imageHandle;
        int labelHandle;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            column.handle = GTK.gtk_tree_view_get_column(this.handle, 0);
            GTK.gtk_tree_view_column_set_sizing(column.handle, 2);
            GTK.gtk_tree_view_column_set_visible(column.handle, false);
            column.modelIndex = 6;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        int boxHandle = this.gtk_box_new(0, false, 3);
        if (boxHandle == 0) {
            this.error(2);
        }
        if ((labelHandle = GTK.gtk_label_new_with_mnemonic(null)) == 0) {
            this.error(2);
        }
        if ((imageHandle = GTK.gtk_image_new()) == 0) {
            this.error(2);
        }
        GTK.gtk_container_add(boxHandle, imageHandle);
        GTK.gtk_container_add(boxHandle, labelHandle);
        GTK.gtk_widget_show(boxHandle);
        GTK.gtk_widget_show(labelHandle);
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        GTK.gtk_tree_view_column_set_widget(column.handle, boxHandle);
        if (GTK.GTK3) {
            column.buttonHandle = GTK.gtk_tree_view_column_get_button(column.handle);
        } else {
            int widget = GTK.gtk_widget_get_parent(boxHandle);
            while (widget != this.handle) {
                if (GTK.GTK_IS_BUTTON(widget)) {
                    column.buttonHandle = widget;
                    break;
                }
                widget = GTK.gtk_widget_get_parent(widget);
            }
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if ((this.state & 0x4000) != 0) {
            column.setFontDescription(this.getFontDescription());
        }
        if (this.columnCount >= 1) {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    String[] strings;
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        Font[] temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellFont = temp;
                    }
                    if ((strings = item.strings) != null) {
                        String[] temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                        temp[index] = "";
                        item.strings = temp;
                    }
                }
                ++i;
            }
        }
    }

    void createItem(TreeItem item, int parentIter, int index) {
        int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        item.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (item.handle == 0) {
            this.error(2);
        }
        if (index == count) {
            GTK.gtk_tree_store_append(this.modelHandle, item.handle, parentIter);
        } else {
            GTK.gtk_tree_store_insert(this.modelHandle, item.handle, parentIter, index);
        }
        int id = this.getId(item.handle, false);
        this.items[id] = item;
        this.modelChanged = true;
    }

    void createRenderers(int columnHandle, int modelIndex, boolean check, int columnStyle) {
        int textRenderer;
        int pixbufRenderer;
        GTK.gtk_tree_view_column_clear(columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            GTK.gtk_tree_view_column_pack_start(columnHandle, this.checkRenderer, false);
            GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.active, 1);
            GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.inconsistent, 2);
            if (!this.ownerDraw && !GTK.GTK3) {
                GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_gdk, 4);
            }
            if (!this.ownerDraw && GTK.GTK3) {
                GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_rgba, 4);
            }
            if (this.ownerDraw) {
                GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, this.checkRenderer, this.display.cellDataProc, this.handle, 0);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            }
        }
        int n = pixbufRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0) : GTK.gtk_cell_renderer_pixbuf_new();
        if (pixbufRenderer == 0) {
            this.error(2);
        } else if (!this.ownerDraw && GTK.GTK3) {
            if ((this.style & 0x10000000) != 0 && this.pixbufSizeSet) {
                GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, this.pixbufHeight, this.pixbufWidth);
            } else {
                GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, 0, 0);
            }
        }
        int n2 = textRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0) : GTK.gtk_cell_renderer_text_new();
        if (textRenderer == 0) {
            this.error(2);
        }
        if (this.ownerDraw) {
            OS.g_object_set_qdata(pixbufRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            OS.g_object_set_qdata(textRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set(pixbufRenderer, OS.mode, 1, 0);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 1.0f, 0);
            GTK.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_pack_end(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 0.5f, 0);
            GTK.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 0.5f);
        } else {
            GTK.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 0.0f);
        }
        GTK.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.pixbuf, modelIndex + 0);
        if (!this.ownerDraw) {
            if (GTK.GTK3) {
                GTK.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_rgba, 4);
                GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_rgba, 4);
            } else {
                GTK.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_gdk, 4);
                GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_gdk, 4);
            }
        }
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, modelIndex + 1);
        if (GTK.GTK3) {
            GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_rgba, 3);
        } else {
            GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_gdk, 3);
        }
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.font_desc, 5);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    customDraw = this.columns[i].customDraw;
                    break;
                }
                ++i;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw || this.ownerDraw) {
            GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, textRenderer, this.display.cellDataProc, this.handle, 0);
            GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, pixbufRenderer, this.display.cellDataProc, this.handle, 0);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
        if (GTK.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handleRGBA;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_unselect_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        if (index == this.columnCount) {
            return;
        }
        int columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        GTK.gtk_tree_view_remove_column(this.handle, columnHandle);
        if (this.columnCount == 0) {
            int oldModel = this.modelHandle;
            int[] types = this.getColumnTypes(1);
            int newModel = GTK.gtk_tree_store_newv(types.length, types);
            if (newModel == 0) {
                this.error(2);
            }
            this.copyModel(oldModel, column.modelIndex, newModel, 6, types, 0, 0, 11);
            GTK.gtk_tree_view_set_model(this.handle, newModel);
            this.setModel(newModel);
            this.createColumn(null, 0);
        } else {
            int i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    int iter = item.handle;
                    int modelIndex = column.modelIndex;
                    GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 0, 0, -1);
                    GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 1, 0, -1);
                    GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 2, 0, -1);
                    GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 3, 0, -1);
                    GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 4, 0, -1);
                    Font[] cellFont = item.cellFont;
                    if (cellFont != null) {
                        if (this.columnCount == 0) {
                            item.cellFont = null;
                        } else {
                            Font[] temp = new Font[this.columnCount];
                            System.arraycopy(cellFont, 0, temp, 0, index);
                            System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                            item.cellFont = temp;
                        }
                    }
                }
                ++i;
            }
            if (index == 0) {
                TreeColumn firstColumn = this.columns[0];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                this.createRenderers(firstColumn.handle, firstColumn.modelIndex, true, firstColumn.style);
            }
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void destroyItem(TreeItem item) {
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_store_remove(this.modelHandle, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        this.modelChanged = true;
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean selected = false;
        if (OS.isX11()) {
            boolean dragDetect;
            if (filter) {
                int[] path = new int[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                    if (path[0] != 0) {
                        int selection = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                            selected = true;
                        }
                        GTK.gtk_tree_path_free(path[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
                consume[0] = true;
            }
            return dragDetect;
        }
        double[] startX = new double[1];
        double[] startY = new double[1];
        int[] path = new int[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
            if (this.getHeaderVisible()) {
                startY[0] = startY[0] - (double)this.getHeaderHeightInPixels();
            }
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)startX[0], (int)startY[0], path, null, null, null)) {
                if (path[0] != 0) {
                    boolean dragDetect = super.dragDetect(x, y, filter, false, consume);
                    if (dragDetect && selected && consume != null) {
                        consume[0] = true;
                    }
                    return dragDetect;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    boolean fixAccessibility() {
        return true;
    }

    @Override
    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            if (column.toolTipText != null) {
                column.setToolTipText(oldShell, null);
                column.setToolTipText(newShell, column.toolTipText);
            }
            ++i;
        }
    }

    @Override
    GdkColor getBackgroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getBaseGdkColor();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        this.checkWidget();
        this.forceResize();
        GTK.gtk_widget_realize(this.handle);
        int fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        int binWindow = GTK.gtk_tree_view_get_bin_window(this.handle);
        int[] binX = new int[1];
        int[] binY = new int[1];
        GDK.gdk_window_get_origin(binWindow, binX, binY);
        int[] fixedX = new int[1];
        int[] fixedY = new int[1];
        GDK.gdk_window_get_origin(fixedWindow, fixedX, fixedY);
        int clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(clientHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        Rectangle rect = new Rectangle(fixedX[0] - binX[0], fixedY[0] - binY[0], width, height);
        return rect;
    }

    @Override
    int getClientWidth() {
        int[] w = new int[1];
        int[] h = new int[1];
        GTK.gtk_widget_realize(this.handle);
        this.gdk_window_get_size(GTK.gtk_tree_view_get_bin_window(this.handle), w, h);
        return w[0];
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        int list = GTK.gtk_tree_view_get_columns(this.handle);
        if (list == 0) {
            return new int[0];
        }
        int i = 0;
        int count = OS.g_list_length(list);
        int[] order = new int[count];
        int temp = list;
        while (temp != 0) {
            int column = OS.g_list_data(temp);
            if (column != 0) {
                int j = 0;
                while (j < this.columnCount) {
                    if (this.columns[j].handle == column) {
                        order[i++] = j;
                        break;
                    }
                    ++j;
                }
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        return order;
    }

    int[] getColumnTypes(int columnCount) {
        int[] types = new int[6 + columnCount * 5];
        types[0] = OS.G_TYPE_INT();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.G_TYPE_BOOLEAN();
        types[3] = GTK.GTK3 ? GDK.GDK_TYPE_RGBA() : GDK.GDK_TYPE_COLOR();
        types[4] = GTK.GTK3 ? GDK.GDK_TYPE_RGBA() : GDK.GDK_TYPE_COLOR();
        types[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        int i = 6;
        while (i < types.length) {
            types[i + 0] = GDK.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = GTK.GTK3 ? GDK.GDK_TYPE_RGBA() : GDK.GDK_TYPE_COLOR();
            types[i + 3] = GTK.GTK3 ? GDK.GDK_TYPE_RGBA() : GDK.GDK_TYPE_COLOR();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            i += 5;
        }
        return types;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        if (this.background != null) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            if (this.foreground != null) {
                return this.foreground;
            }
            return this.display.COLOR_LIST_FOREGROUND_RGBA;
        }
        return super.getContextColorGdkRGBA();
    }

    TreeItem getFocusItem() {
        int[] path = new int[1];
        GTK.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            int[] index = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
            if (index[0] != -1) {
                item = this.items[index[0]];
            }
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        return item;
    }

    @Override
    GdkColor getForegroundGdkColor() {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        return this.getTextColor();
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground != null ? this.headerBackground : this.display.getSystemColor(25);
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground != null ? this.headerForeground : this.display.getSystemColor(24);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        if (this.columnCount > 0) {
            GtkRequisition requisition = new GtkRequisition();
            int height = 0;
            int i = 0;
            while (i < this.columnCount) {
                int buttonHandle = this.columns[i].buttonHandle;
                if (buttonHandle != 0) {
                    this.gtk_widget_get_preferred_size(buttonHandle, requisition);
                    height = Math.max(height, requisition.height);
                }
                ++i;
            }
            return height;
        }
        GTK.gtk_widget_realize(this.handle);
        int fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
        int binWindow = GTK.gtk_tree_view_get_bin_window(this.handle);
        int[] binY = new int[1];
        GDK.gdk_window_get_origin(binWindow, null, binY);
        int[] fixedY = new int[1];
        GDK.gdk_window_get_origin(fixedWindow, null, fixedY);
        return binY[0] - fixedY[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_headers_visible(this.handle);
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0)) {
            this.error(6);
        }
        return this._getItem(0, index);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TreeItem getItemInPixels(Point point) {
        int[] columnHandle;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int[] path = new int[1];
        GTK.gtk_widget_realize(this.handle);
        int x = point.x;
        int y = point.y;
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, columnHandle = new int[1], null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        TreeItem item = null;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            boolean overExpander = false;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == columnHandle[0]) {
                GdkRectangle rect = new GdkRectangle();
                GTK.gtk_tree_view_get_cell_area(this.handle, path[0], columnHandle[0], rect);
                if ((this.style & 0x8000000) != 0) {
                    overExpander = x > rect.x + rect.width;
                } else {
                    boolean bl = overExpander = x < rect.x;
                }
            }
            if (!overExpander) {
                item = this._getItem(iter);
            }
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
        if (itemCount == 0) {
            int column = GTK.gtk_tree_view_get_column(this.handle, 0);
            int[] w = new int[1];
            int[] h = new int[1];
            this.ignoreSize = true;
            GTK.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            int height = h[0];
            if (GTK.GTK3) {
                int textRenderer = this.getTextRenderer(column);
                if (textRenderer != 0) {
                    GTK.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
                }
                height += h[0];
            }
            this.ignoreSize = false;
            return height;
        }
        int height = 0;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_get_iter_first(this.modelHandle, iter);
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = GTK.gtk_tree_view_get_column(this.handle, i);
            GTK.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
            int[] w = new int[1];
            int[] h = new int[1];
            GTK.gtk_tree_view_column_cell_get_size(column, null, null, null, w, h);
            if (GTK.GTK3) {
                int textRenderer = this.getTextRenderer(column);
                int[] ypad = new int[1];
                if (textRenderer != 0) {
                    GTK.gtk_cell_renderer_get_padding(textRenderer, null, ypad);
                }
                height = Math.max(height, h[0] + ypad[0]);
            } else {
                height = Math.max(height, h[0]);
            }
            ++i;
        }
        OS.g_free(iter);
        return height;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0);
    }

    TreeItem[] getItems(int parent) {
        int length = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parent);
        TreeItem[] result = new TreeItem[length];
        if (length == 0) {
            return result;
        }
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < length) {
                result[i] = this._getItem(parent, i);
                ++i;
            }
        } else {
            int i = 0;
            int[] index = new int[1];
            int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parent);
            while (valid) {
                GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
                result[i++] = this.items[index[0]];
                valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
            }
            OS.g_free(iter);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (GTK.GTK3) {
            return GTK.gtk_tree_view_get_grid_lines(this.handle) > 0;
        }
        return GTK.gtk_tree_view_get_rules_hint(this.handle);
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    int getPixbufRenderer(int column) {
        int list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0) {
            return 0;
        }
        int originalList = list;
        int pixbufRenderer = 0;
        while (list != 0) {
            int renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_PIXBUF(renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return pixbufRenderer;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        int list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0) {
            int originalList = list;
            int count = OS.g_list_length(list);
            TreeItem[] treeSelection = new TreeItem[count];
            int length = 0;
            int i = 0;
            while (i < count) {
                int data = OS.g_list_data(list);
                int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, data)) {
                    treeSelection[length] = this._getItem(iter);
                    ++length;
                }
                list = OS.g_list_next(list);
                OS.g_free(iter);
                GTK.gtk_tree_path_free(data);
                ++i;
            }
            OS.g_list_free(originalList);
            if (length < count) {
                TreeItem[] temp = new TreeItem[length];
                System.arraycopy(treeSelection, 0, temp, 0, length);
                treeSelection = temp;
            }
            return treeSelection;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(selection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    int getTextRenderer(int column) {
        int list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0) {
            return 0;
        }
        int originalList = list;
        int textRenderer = 0;
        while (list != 0) {
            int renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        int vAdjustment = GTK.GTK3 ? GTK.gtk_scrollable_get_vadjustment(this.handle) : GTK.gtk_tree_view_get_vadjustment(this.handle);
        this.currentAdjustment = GTK._gtk_adjustment_get_value(vAdjustment);
        TreeItem item = null;
        if (this.cachedAdjustment == this.currentAdjustment) {
            item = this._getCachedTopItem();
        }
        if (item != null && !item.isDisposed()) {
            return item;
        }
        int[] path = new int[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return null;
        }
        if (path[0] == 0) {
            return null;
        }
        item = null;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        this.topItem = item;
        return item;
    }

    TreeItem _getCachedTopItem() {
        int treeSelect = GTK.gtk_tree_view_get_selection(this.handle);
        int list = GTK.gtk_tree_selection_get_selected_rows(treeSelect, null);
        TreeItem treeSelection = null;
        if (list != 0) {
            int data;
            int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, data = OS.g_list_data(list))) {
                treeSelection = this._getItem(iter);
            }
            OS.g_free(iter);
            GTK.gtk_tree_path_free(data);
            if (this.topItem == treeSelection) {
                return this.topItem;
            }
            return treeSelection;
        }
        if (this.topItem == null) {
            TreeItem item = null;
            int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.modelHandle, iter)) {
                item = this._getItem(iter);
            }
            OS.g_free(iter);
            return item;
        }
        return this.topItem;
    }

    @Override
    int gtk_button_press_event(int widget, int event) {
        int button;
        int selection;
        int[] path;
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        if (gdkEvent.window != GTK.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        int result = super.gtk_button_press_event(widget, event);
        if (result != 0) {
            return result;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11() && gdkEvent.type == 4) {
            int nextEvent = GDK.gdk_event_peek();
            if (nextEvent == 0) {
                path = new int[1];
                selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path, null, null, null) && path[0] != 0) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(selection, path[0]) && ((gdkEvent.state & 5) == 0 || (gdkEvent.state & 4) != 0)) {
                        int gtk_false_funcPtr = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(selection, gtk_false_funcPtr, 0, 0);
                    }
                }
            } else {
                GDK.gdk_event_free(nextEvent);
            }
        }
        if ((button = gdkEvent.button) == 3 && gdkEvent.type == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1;
            }
            GTK.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path = new int[1], null, null, null) && path[0] != 0) {
            selection = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
            GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            GTK.gtk_tree_path_free(path[0]);
        }
        if (gdkEvent.type == 5) {
            this.sendTreeDefaultSelection();
        }
        return result;
    }

    @Override
    int gtk_key_press_event(int widget, int event) {
        GdkEventKey keyEvent = new GdkEventKey();
        OS.memmove(keyEvent, event, GdkEventKey.sizeof);
        int key = keyEvent.keyval;
        this.keyPressDefaultSelectionHandler(event, key);
        return super.gtk_key_press_event(widget, event);
    }

    void keyPressDefaultSelectionHandler(int event, int key) {
        int keymask = this.gdk_event_get_state(event);
        switch (key) {
            case 65293: {
                if ((keymask & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
    }

    void sendTreeDefaultSelection() {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem == null) {
            return;
        }
        Event event = new Event();
        event.item = treeItem;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    int gtk_button_release_event(int widget, int event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
        this.lastInput.x = (int)gdkEvent.x;
        this.lastInput.y = (int)gdkEvent.y;
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0;
        }
        if (gdkEvent.window != GTK.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && !OS.isX11()) {
            int[] path = new int[1];
            int selection = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(selection, 0, 0, 0);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)gdkEvent.x, (int)gdkEvent.y, path, null, null, null) && path[0] != 0 && GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((gdkEvent.state & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0, false);
                }
                if ((gdkEvent.state & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(selection, path[0]);
                }
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    @Override
    int gtk_changed(int widget) {
        TreeItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    @Override
    int gtk_event_after(int widget, int gdkEvent) {
        switch (GDK.GDK_EVENT_TYPE(gdkEvent)) {
            case 2: {
                if (GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0) != 0) break;
                this.gtk_expose_event(widget, gdkEvent);
            }
        }
        return super.gtk_event_after(widget, gdkEvent);
    }

    @Override
    int gtk_expand_collapse_cursor_row(int widget, int logical, int expand, int open_all) {
        if (expand != 0 && open_all != 0) {
            this.expandAll = true;
        }
        return 0;
    }

    void drawInheritedBackground(int eventPtr, int cairo) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            int window = GTK.gtk_tree_view_get_bin_window(this.handle);
            int rgn = 0;
            if (eventPtr != 0) {
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, eventPtr, GdkEventExpose.sizeof);
                if (window != gdkEvent.window) {
                    return;
                }
                rgn = gdkEvent.region;
            }
            int[] width = new int[1];
            int[] height = new int[1];
            this.gdk_window_get_size(window, width, height);
            int parent = 0;
            int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parent);
            GdkRectangle rect = new GdkRectangle();
            boolean expanded = true;
            while (itemCount != 0 && expanded && height[0] > rect.y + rect.height) {
                int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parent, itemCount - 1);
                itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, iter);
                int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                GTK.gtk_tree_view_get_cell_area(this.handle, path, 0, rect);
                expanded = GTK.gtk_tree_view_row_expanded(this.handle, path);
                GTK.gtk_tree_path_free(path);
                if (parent != 0) {
                    OS.g_free(parent);
                }
                parent = iter;
            }
            if (parent != 0) {
                OS.g_free(parent);
            }
            if (height[0] > rect.y + rect.height) {
                this.drawBackground(control, window, cairo, rgn, 0, rect.y + rect.height, width[0], height[0] - (rect.y + rect.height));
            }
        }
    }

    @Override
    int gtk_draw(int widget, int cairo) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(0, cairo);
        return super.gtk_draw(widget, cairo);
    }

    @Override
    int gtk_expose_event(int widget, int eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0;
        }
        this.drawInheritedBackground(eventPtr, 0);
        return super.gtk_expose_event(widget, eventPtr);
    }

    @Override
    int gtk_motion_notify_event(int widget, int event) {
        int window = GDK.GDK_EVENT_WINDOW(event);
        if (window != GTK.gtk_tree_view_get_bin_window(this.handle)) {
            return 0;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    @Override
    int gtk_row_deleted(int model, int path) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_deleted);
        }
        return 0;
    }

    @Override
    int gtk_row_has_child_toggled(int model, int path, int iter) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        if (index[0] >= this.items.length) {
            return 0;
        }
        TreeItem item = this.items[index[0]];
        if (item == null) {
            return 0;
        }
        int childCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, item.handle);
        if (childCount != 0 && item.isExpanded) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 51);
            GTK.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 51);
        }
        return 0;
    }

    @Override
    int gtk_row_inserted(int model, int path, int iter) {
        if (this.ignoreAccessibility) {
            OS.g_signal_stop_emission_by_name(model, OS.row_inserted);
        }
        return 0;
    }

    @Override
    int gtk_start_interactive_search(int widget) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(widget, OS.start_interactive_search);
            return 1;
        }
        return 0;
    }

    @Override
    int gtk_test_collapse_row(int tree, int iter, int path) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean changed = this.modelChanged || !GTK.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1;
        }
        item.isExpanded = false;
        if (changed) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 50);
            GTK.gtk_tree_view_collapse_row(this.handle, path);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 50);
            return 1;
        }
        return 0;
    }

    @Override
    int gtk_test_expand_row(int tree, int iter, int path) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean changed = this.modelChanged || GTK.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1;
        }
        item.isExpanded = true;
        if (changed || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 51);
            GTK.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 51);
            return 1;
        }
        return 0;
    }

    @Override
    int gtk_toggled(int renderer, int pathStr) {
        int path = GTK.gtk_tree_path_new_from_string(pathStr);
        if (path == 0) {
            return 0;
        }
        TreeItem item = null;
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path)) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path);
        if (item != null) {
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0;
    }

    @Override
    void gtk_widget_size_request(int widget, GtkRequisition requisition) {
        int columns;
        if (this.columnCount == 0) {
            super.gtk_widget_size_request(widget, requisition);
            return;
        }
        int list = columns = GTK.gtk_tree_view_get_columns(this.handle);
        boolean fixVisible = columns != 0;
        while (list != 0) {
            int column = OS.g_list_data(list);
            if (GTK.gtk_tree_view_column_get_visible(column)) {
                fixVisible = false;
                break;
            }
            list = OS.g_list_next(list);
        }
        int columnHandle = 0;
        if (fixVisible) {
            columnHandle = OS.g_list_data(columns);
            GTK.gtk_tree_view_column_set_visible(columnHandle, true);
        }
        super.gtk_widget_size_request(widget, requisition);
        if (fixVisible) {
            GTK.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (columns != 0) {
            OS.g_list_free(columns);
        }
    }

    void hideFirstColumn() {
        int firstColumn = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(firstColumn, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.getClosure(51), false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.getClosure(50), false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.getClosure(17), false);
        OS.g_signal_connect_closure(this.modelHandle, OS.row_has_child_toggled, this.display.getClosure(84), false);
        if (this.checkRenderer != 0) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        int indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        int depth = GTK.gtk_tree_path_get_depth(path);
        if (depth == 1 && (indices = GTK.gtk_tree_path_get_indices(path)) != 0) {
            int[] temp = new int[1];
            C.memmove(temp, indices, 4);
            index = temp[0];
        }
        GTK.gtk_tree_path_free(path);
        return index;
    }

    @Override
    boolean mnemonicHit(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        int i = 0;
        while (i < this.columnCount) {
            int labelHandle = this.columns[i].labelHandle;
            if (labelHandle != 0 && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    int paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK.gtk_tree_view_get_bin_window(this.handle);
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            int n = this.checkRenderer = this.ownerDraw ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0) : GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(GTK.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            int i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                this.createRenderers(column.handle, column.modelIndex, i == 0, column.style);
                ++i;
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem item, boolean release) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, item.handle, 0, index, -1);
        if (index[0] == -1) {
            return;
        }
        if (release) {
            item.release(false);
        }
        this.items[index[0]] = null;
    }

    void releaseItems(int parentIter) {
        int[] index = new int[1];
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        while (valid) {
            this.releaseItems(iter);
            if (!this.isDisposed()) {
                TreeItem item;
                GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
                if (index[0] != -1 && (item = this.items[index[0]]) != null) {
                    this.releaseItem(item, true);
                }
            }
            valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0;
        if (this.checkRenderer != 0) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    void remove(int parentIter, int start, int end) {
        if (start > end) {
            return;
        }
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (start < 0 || start > end || end >= itemCount) {
            this.error(6);
        }
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0) {
            this.error(2);
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        int i = start;
        while (i <= end) {
            TreeItem item;
            GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, start);
            int[] value = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            TreeItem treeItem = item = value[0] != -1 ? this.items[value[0]] : null;
            if (item != null && !item.isDisposed()) {
                item.dispose();
            } else {
                OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
                GTK.gtk_tree_store_remove(this.modelHandle, iter);
                OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
            }
            ++i;
        }
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_free(iter);
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = new TreeItem[4];
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = true;
        }
        GTK.gtk_tree_view_set_model(this.handle, 0);
        GTK.gtk_tree_store_clear(this.modelHandle);
        GTK.gtk_tree_view_set_model(this.handle, this.modelHandle);
        if (this.fixAccessibility()) {
            this.ignoreAccessibility = false;
            OS.g_object_notify(this.handle, OS.model);
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void sendMeasureEvent(int cell, int width, int height) {
        if (!this.ignoreSize && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(41)) {
            int iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
            TreeItem item = null;
            if (iter != 0) {
                item = this._getItem(iter);
            }
            if (item != null && !item.isDisposed()) {
                int columnIndex = 0;
                if (this.columnCount > 0) {
                    int columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
                    int i = 0;
                    while (i < this.columnCount) {
                        if (this.columns[i].handle == columnHandle) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                int[] contentWidth = new int[1];
                int[] contentHeight = new int[1];
                if (width != 0) {
                    C.memmove(contentWidth, width, 4);
                }
                if (height != 0) {
                    C.memmove(contentHeight, height, 4);
                }
                if (GTK.GTK3) {
                    GTK.gtk_cell_renderer_get_preferred_height_for_width(cell, this.handle, contentWidth[0], contentHeight, null);
                }
                Image image = item.getImage(columnIndex);
                int imageWidth = 0;
                if (image != null && !image.isDisposed()) {
                    Rectangle bounds = GTK.GTK3 && DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                    bounds = image.getBounds();
                    imageWidth = bounds.width;
                }
                contentWidth[0] = contentWidth[0] + imageWidth;
                GC gc = new GC(this);
                gc.setFont(item.getFont(columnIndex));
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                Rectangle eventRect = new Rectangle(0, 0, contentWidth[0], contentHeight[0]);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                int selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_selection_path_is_selected(selection, path)) {
                    event.detail = 2;
                }
                GTK.gtk_tree_path_free(path);
                this.sendEvent(41, event);
                gc.dispose();
                Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
                contentWidth[0] = rect.width - imageWidth;
                if (contentHeight[0] < rect.height) {
                    contentHeight[0] = rect.height;
                }
                if (width != 0) {
                    C.memmove(width, contentWidth, 4);
                }
                if (height != 0) {
                    C.memmove(height, contentHeight, 4);
                }
                if (GTK.GTK3) {
                    GTK.gtk_cell_renderer_set_fixed_size(cell, -1, contentHeight[0]);
                }
            }
        }
    }

    @Override
    int rendererGetPreferredWidthProc(int cell, int handle, int minimun_size, int natural_size) {
        int g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call(klass.get_preferred_width, cell, handle, minimun_size, natural_size);
        this.sendMeasureEvent(cell, minimun_size, 0);
        return 0;
    }

    @Override
    int rendererGetSizeProc(int cell, int widget, int cell_area, int x_offset, int y_offset, int width, int height) {
        int g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call_get_size(klass.get_size, cell, this.handle, cell_area, x_offset, y_offset, width, height);
        this.sendMeasureEvent(cell, width, height);
        return 0;
    }

    @Override
    int rendererRenderProc(int cell, int cr, int widget, int background_area, int cell_area, int flags) {
        this.rendererRender(cell, cr, 0, widget, background_area, cell_area, 0, flags);
        return 0;
    }

    @Override
    int rendererRenderProc(int cell, int window, int widget, int background_area, int cell_area, int expose_area, int flags) {
        this.rendererRender(cell, 0, window, widget, background_area, cell_area, expose_area, flags);
        return 0;
    }

    void rendererRender(int cell, int cr, int window, int widget, int background_area, int cell_area, int expose_area, int flags) {
        GdkRectangle rect;
        TreeItem item = null;
        boolean wasSelected = false;
        int iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
        if (iter != 0) {
            item = this._getItem(iter);
        }
        int columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
        int columnIndex = 0;
        if (this.columnCount > 0) {
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].handle == columnHandle) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (item != null && (GTK.GTK_IS_CELL_RENDERER_TOGGLE(cell) || (GTK.GTK_IS_CELL_RENDERER_PIXBUF(cell) || GTK.GTK_VERSION > OS.VERSION(3, 13, 0)) && (columnIndex != 0 || (this.style & 0x20) == 0))) {
            int textRenderer;
            Control control;
            this.drawFlags = flags;
            this.drawState = 16;
            int[] ptr = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, item.handle, 4, ptr, -1);
            if (ptr[0] == 0) {
                int modelIndex = this.columnCount == 0 ? 6 : this.columns[columnIndex].modelIndex;
                GTK.gtk_tree_model_get(this.modelHandle, item.handle, modelIndex + 3, ptr, -1);
            }
            if (ptr[0] != 0) {
                this.drawState |= 8;
                if (GTK.GTK3) {
                    GDK.gdk_rgba_free(ptr[0]);
                } else {
                    GDK.gdk_color_free(ptr[0]);
                }
            }
            if ((flags & 1) != 0) {
                this.drawState |= 2;
            }
            if (!(GTK.GTK3 && (flags & 1) != 0 || (flags & 0x10) == 0)) {
                this.drawState |= 4;
            }
            rect = new GdkRectangle();
            int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect);
            GTK.gtk_tree_path_free(path);
            if (cr != 0 && GTK.GTK3) {
                GdkRectangle r2 = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(cr, r2);
                rect.x = r2.x;
                rect.width = r2.width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (cr != 0) {
                    Cairo.cairo_save(cr);
                    if (!GTK.GTK3) {
                        Cairo.cairo_reset_clip(cr);
                    }
                }
                this.drawBackground(control, window, cr, 0, rect.x, rect.y, rect.width, rect.height);
                if (cr != 0) {
                    Cairo.cairo_restore(cr);
                }
            }
            if ((textRenderer = this.getTextRenderer(columnHandle)) != 0) {
                this.gtk_cell_renderer_get_preferred_size(textRenderer, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Rectangle rect2;
                boolean bl = wasSelected = (this.drawState & 2) != 0;
                if (wasSelected) {
                    Control control2 = this.findBackgroundControl();
                    if (control2 == null) {
                        control2 = this;
                    }
                    if (!GTK.GTK3) {
                        if (cr != 0) {
                            Cairo.cairo_save(cr);
                            Cairo.cairo_reset_clip(cr);
                        }
                        this.drawBackground(control2, window, cr, 0, rect.x, rect.y, rect.width, rect.height);
                        if (cr != 0) {
                            Cairo.cairo_restore(cr);
                        }
                    }
                }
                GC gc = this.getGC(cr);
                if ((this.drawState & 2) != 0) {
                    gc.setBackground(this.display.getSystemColor(26));
                    gc.setForeground(this.display.getSystemColor(27));
                } else {
                    gc.setBackground(item.getBackground(columnIndex));
                    gc.setForeground(item.getForeground(columnIndex));
                }
                gc.setFont(item.getFont(columnIndex));
                if ((this.style & 0x8000000) != 0) {
                    rect.x = this.getClientWidth() - rect.width - rect.x;
                }
                if (GTK.GTK3 && cr != 0) {
                    rect2 = DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height));
                    gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
                } else {
                    rect2 = DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height));
                    gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
                }
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                Rectangle eventRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                event.detail = this.drawState;
                this.sendEvent(40, event);
                if (GTK.GTK3) {
                    this.drawForegroundRGBA = null;
                } else {
                    this.drawForeground = null;
                }
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) != 0) {
                    if (!GTK.GTK3) {
                        int style = GTK.gtk_widget_get_style(widget);
                        byte[] detail = Converter.wcsToMbcs("cell_odd", true);
                        GTK.gtk_paint_flat_box(style, window, 3, 0, rect, widget, detail, rect.x, rect.y, rect.width, rect.height);
                    }
                } else if (wasSelected) {
                    if (GTK.GTK3) {
                        this.drawForegroundRGBA = gc.getForeground().handleRGBA;
                    } else {
                        this.drawForeground = gc.getForeground().handle;
                    }
                }
                gc.dispose();
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gc = this.getGC(cr);
            gc.setBackground(item.getBackground(columnIndex));
            rect = new GdkRectangle();
            OS.memmove(rect, background_area, GdkRectangle.sizeof);
            gc.fillRectangle(DPIUtil.autoScaleDown(new Rectangle(rect.x, rect.y, rect.width, rect.height)));
            gc.dispose();
        }
        if ((this.drawState & 0x10) != 0 || GTK.GTK_IS_CELL_RENDERER_TOGGLE(cell)) {
            int g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
            GtkCellRendererClass klass = new GtkCellRendererClass();
            OS.memmove(klass, g_class);
            if (this.drawForeground != null && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && !GTK.GTK3) {
                OS.g_object_set(cell, OS.foreground_gdk, this.drawForeground, 0);
            } else if (this.drawForegroundRGBA != null && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && GTK.GTK3) {
                OS.g_object_set(cell, OS.foreground_rgba, this.drawForegroundRGBA, 0);
            }
            if (GTK.GTK3) {
                OS.call(klass.render, cell, cr, widget, background_area, cell_area, this.drawFlags);
            } else {
                OS.call(klass.render, cell, window, widget, background_area, cell_area, expose_area, this.drawFlags);
            }
        }
        if (item != null && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(42)) {
            if (wasSelected) {
                this.drawState |= 2;
            }
            GdkRectangle rect2 = new GdkRectangle();
            int path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_get_background_area(this.handle, path, columnHandle, rect2);
            GTK.gtk_tree_path_free(path);
            if (cr != 0 && GTK.GTK_VERSION > OS.VERSION(3, 9, 0) && GTK.GTK_VERSION <= OS.VERSION(3, 14, 8)) {
                GdkRectangle r2 = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(cr, r2);
                rect2.x = r2.x;
                rect2.width = r2.width;
            }
            this.ignoreSize = true;
            int[] contentX = new int[1];
            int[] contentWidth = new int[1];
            this.gtk_cell_renderer_get_preferred_size(cell, this.handle, contentWidth, null);
            this.gtk_tree_view_column_cell_get_position(columnHandle, cell, contentX, null);
            this.ignoreSize = false;
            Image image = item.getImage(columnIndex);
            int imageWidth = 0;
            if (image != null) {
                Rectangle bounds = GTK.GTK3 && DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                imageWidth = bounds.width;
            }
            if (cr != 0 && GTK.GTK3) {
                rect2.x -= imageWidth;
                rect2.width += imageWidth;
            }
            contentX[0] = contentX[0] - imageWidth;
            contentWidth[0] = contentWidth[0] + imageWidth;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == columnHandle) {
                GdkRectangle rect3 = new GdkRectangle();
                GTK.gtk_widget_realize(this.handle);
                path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                GTK.gtk_tree_view_get_cell_area(this.handle, path, columnHandle, rect3);
                contentX[0] = contentX[0] + rect3.x;
            }
            GC gc = this.getGC(cr);
            if ((this.drawState & 2) != 0) {
                Color foreground;
                Color background;
                if (GTK.gtk_widget_has_focus(this.handle) || GTK.GTK3) {
                    background = this.display.getSystemColor(26);
                    foreground = this.display.getSystemColor(27);
                } else {
                    background = Color.gtk_new((Device)this.display, this.display.COLOR_LIST_SELECTION_INACTIVE);
                    foreground = Color.gtk_new((Device)this.display, this.display.COLOR_LIST_SELECTION_TEXT_INACTIVE);
                }
                gc.setBackground(background);
                gc.setForeground(foreground);
            } else {
                gc.setBackground(item.getBackground(columnIndex));
                Color foreground = GTK.GTK3 ? (this.drawForegroundRGBA != null ? Color.gtk_new((Device)this.display, this.drawForegroundRGBA) : item.getForeground(columnIndex)) : (this.drawForeground != null ? Color.gtk_new((Device)this.display, this.drawForeground) : item.getForeground(columnIndex));
                gc.setForeground(foreground);
            }
            gc.setFont(item.getFont(columnIndex));
            if ((this.style & 0x8000000) != 0) {
                rect2.x = this.getClientWidth() - rect2.width - rect2.x;
            }
            Rectangle rect22 = DPIUtil.autoScaleDown(new Rectangle(rect2.x, rect2.y, rect2.width, rect2.height));
            gc.setClipping(rect22.x, rect22.y, rect22.width, rect22.height);
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            Rectangle eventRect = new Rectangle(rect2.x + contentX[0], rect2.y, contentWidth[0], rect2.height);
            event.setBounds(DPIUtil.autoScaleDown(eventRect));
            event.detail = this.drawState;
            this.sendEvent(42, event);
            gc.dispose();
        }
    }

    private GC getGC(int cr) {
        GC gc;
        if (GTK.GTK3) {
            GCData gcData = new GCData();
            gcData.cairo = cr;
            gc = GC.gtk_new(this, gcData);
        } else {
            gc = new GC(this);
        }
        return gc;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.ownerDraw) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        int i = 0;
        while (i < end) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (customDraw) {
                int column = GTK.gtk_tree_view_get_column(this.handle, i);
                int textRenderer = this.getTextRenderer(column);
                GTK.gtk_tree_view_column_set_cell_data_func(column, textRenderer, 0, 0, 0);
                if (this.columnCount != 0) {
                    this.columns[i].customDraw = false;
                }
            }
            ++i;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                if (column != null) {
                    column.reskinChildren(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item == null) {
            GTK.gtk_tree_view_set_drag_dest_row(this.handle, 0, 0);
            return;
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        Rectangle rect = item.getBoundsInPixels();
        int[] path = new int[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, rect.x, rect.y, path, null, null, null)) {
            return;
        }
        if (path[0] == 0) {
            return;
        }
        int position = before ? 0 : 1;
        GTK.gtk_tree_view_set_drag_dest_row(this.handle, path[0], position);
        GTK.gtk_tree_path_free(path[0]);
    }

    void setItemCount(int parentIter, int count) {
        boolean isVirtual;
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (count == itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        this.remove(parentIter, count, itemCount - 1);
        if (isVirtual) {
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = true;
            }
            int i = itemCount;
            while (i < count) {
                int iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                if (iter == 0) {
                    this.error(2);
                }
                GTK.gtk_tree_store_append(this.modelHandle, iter, parentIter);
                GTK.gtk_tree_store_set(this.modelHandle, iter, 0, -1, -1);
                OS.g_free(iter);
                ++i;
            }
            if (this.fixAccessibility()) {
                this.ignoreAccessibility = false;
                OS.g_object_notify(this.handle, OS.model);
            }
        } else {
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, parentIter, 0, i, true);
                ++i;
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.setItemCount(0, count);
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_select_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        GTK.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    @Override
    void setBackgroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        super.setBackgroundGdkColor(color);
        GTK.gtk_widget_modify_base(this.handle, 0, color);
    }

    @Override
    void setBackgroundGdkRGBA(int context, int handle, GdkRGBA rgba) {
        assert (GTK.GTK3) : "GTK3 code was run by GTK2";
        this.background = rgba == null ? this.defaultBackground() : rgba;
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handleRGBA;
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            String css;
            String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "treeview" : "GtkTreeView";
            this.cssBackground = css = String.valueOf(name) + " {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\n" + name + ":selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
            this.gtk_css_provider_load_from_css(context, finalCss);
        } else {
            super.setBackgroundGdkRGBA(context, handle, rgba);
            GTK.gtk_widget_override_background_color(handle, 4, selectedBackground);
        }
    }

    @Override
    void setBackgroundPixmap(Image image) {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        GTK.gtk_widget_realize(this.handle);
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length > 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            ++i;
        }
        int baseColumn = 0;
        int i2 = 0;
        while (i2 < order.length) {
            int column = this.columns[order[i2]].handle;
            GTK.gtk_tree_view_move_column_after(this.handle, column, baseColumn);
            baseColumn = column;
            ++i2;
        }
    }

    @Override
    void setFontDescription(int font) {
        super.setFontDescription(font);
        TreeColumn[] columns = this.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                columns[i].setFontDescription(font);
            }
            ++i;
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        if (GTK.GTK_VERSION >= OS.VERSION(3, 14, 0)) {
            this.foreground = rgba;
            GdkRGBA toSet = rgba == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : rgba;
            this.setForegroundGdkRGBA(this.handle, toSet);
        } else {
            super.setForegroundGdkRGBA(rgba);
        }
    }

    @Override
    void setForegroundGdkColor(GdkColor color) {
        assert (!GTK.GTK3) : "GTK2 code was run by GTK3";
        this.setForegroundColor(this.handle, color, false);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerBackground)) {
                return;
            }
        } else if (this.headerBackground == null) {
            return;
        }
        this.headerBackground = color;
        if (GTK.GTK3) {
            String css;
            GdkRGBA background = this.headerBackground != null ? this.headerBackground.handleRGBA : this.defaultBackground();
            String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
            this.headerCSSBackground = css = String.valueOf(name) + " {background: " + this.display.gtk_rgba_to_css_string(background) + ";}\n";
            String finalCss = this.display.gtk_css_create_css_color_string(this.headerCSSBackground, this.headerCSSForeground, 8);
            TreeColumn[] treeColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (column != null) {
                    int context = GTK.gtk_widget_get_style_context(column.buttonHandle);
                    int provider = GTK.gtk_css_provider_new();
                    GTK.gtk_style_context_add_provider(context, provider, 600);
                    OS.g_object_unref(provider);
                    GTK.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(finalCss, true), -1, null);
                    GTK.gtk_style_context_invalidate(context);
                }
                ++n2;
            }
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerForeground)) {
                return;
            }
        } else if (this.headerForeground == null) {
            return;
        }
        this.headerForeground = color;
        if (GTK.GTK3) {
            String css;
            GdkRGBA foreground = this.headerForeground != null ? this.headerForeground.handleRGBA : this.display.COLOR_LIST_FOREGROUND_RGBA;
            String name = GTK.GTK_VERSION >= OS.VERSION(3, 20, 0) ? "button" : "GtkButton";
            this.headerCSSForeground = css = String.valueOf(name) + " {color: " + this.display.gtk_rgba_to_css_string(foreground) + ";}";
            String finalCss = this.display.gtk_css_create_css_color_string(this.headerCSSBackground, this.headerCSSForeground, 16);
            TreeColumn[] treeColumnArray = this.columns;
            int n = this.columns.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (column != null) {
                    int context = GTK.gtk_widget_get_style_context(column.buttonHandle);
                    int provider = GTK.gtk_css_provider_new();
                    GTK.gtk_style_context_add_provider(context, provider, 600);
                    OS.g_object_unref(provider);
                    GTK.gtk_css_provider_load_from_data(provider, Converter.wcsToMbcs(finalCss, true), -1, null);
                    GTK.gtk_style_context_invalidate(context);
                }
                ++n2;
            }
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        GTK.gtk_tree_view_set_headers_visible(this.handle, show);
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (!GTK.GTK3) {
            GTK.gtk_tree_view_set_rules_hint(this.handle, show);
        }
        GTK.gtk_tree_view_set_grid_lines(this.handle, show ? 2 : 0);
    }

    void setModel(int newModel) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = newModel;
        this.display.addWidget(this.modelHandle, this);
        if (this.fixAccessibility()) {
            OS.g_signal_connect_closure(this.modelHandle, OS.row_inserted, this.display.getClosure(64), true);
            OS.g_signal_connect_closure(this.modelHandle, OS.row_deleted, this.display.getClosure(65), true);
        }
    }

    @Override
    void setOrientation(boolean create) {
        int i;
        super.setOrientation(create);
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                if (this.items[i] != null) {
                    this.items[i].setOrientation(create);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                if (this.columns[i] != null) {
                    this.columns[i].setOrientation(create);
                }
                ++i;
            }
        }
    }

    @Override
    void setParentBackground() {
        this.ownerDraw = true;
        this.recreateRenderers();
    }

    @Override
    void setParentGdkWindow(Control child) {
        int parentGdkWindow = this.eventWindow();
        GTK.gtk_widget_set_parent_window(child.topHandle(), parentGdkWindow);
        if (GTK.GTK_VERSION >= OS.VERSION(3, 10, 0)) {
            this.hasChildren = true;
            this.connectFixedHandleDraw();
        }
    }

    void setScrollWidth(int column, TreeItem item) {
        int itemWidth;
        if (this.columnCount != 0 || this.currentItem == item) {
            return;
        }
        int width = GTK.gtk_tree_view_column_get_fixed_width(column);
        if (width < (itemWidth = this.calculateWidth(column, item.handle, true))) {
            GTK.gtk_tree_view_column_set_fixed_width(column, itemWidth);
        }
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        int selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0, 0, 6);
        boolean first = true;
        int i = 0;
        while (i < length) {
            TreeItem item = items[i];
            if (item != null) {
                if (item.isDisposed()) break;
                if (item.parent == this) {
                    int path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
                    this.showItem(path, false);
                    if (first) {
                        GTK.gtk_tree_view_set_cursor(this.handle, path, 0, false);
                    }
                    GTK.gtk_tree_selection_select_iter(selection, item.handle);
                    GTK.gtk_tree_path_free(path);
                    first = false;
                }
            }
            ++i;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0, 0, 6);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem item) {
        int vAdjustment = GTK.GTK3 ? GTK.gtk_scrollable_get_vadjustment(this.handle) : GTK.gtk_tree_view_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        this.topItem = item;
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, false);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(path);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        GTK.gtk_tree_view_scroll_to_cell(this.handle, 0, column.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int columnCount = Math.max(1, this.columnCount);
        int i = 0;
        while (i < columnCount) {
            int column = GTK.gtk_tree_view_get_column(this.handle, i);
            if (GTK.gtk_tree_view_column_get_visible(column)) {
                return false;
            }
            ++i;
        }
        int firstColumn = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(firstColumn, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] items = this.getSelection();
        if (items.length != 0 && items[0] != null) {
            this.showItem(items[0]);
        }
    }

    void showItem(int path, boolean scroll) {
        int depth = GTK.gtk_tree_path_get_depth(path);
        if (depth > 1) {
            int[] indices = new int[depth - 1];
            int indicesPtr = GTK.gtk_tree_path_get_indices(path);
            C.memmove(indices, indicesPtr, indices.length * 4);
            int tempPath = GTK.gtk_tree_path_new();
            int i = 0;
            while (i < indices.length) {
                GTK.gtk_tree_path_append_index(tempPath, indices[i]);
                GTK.gtk_tree_view_expand_row(this.handle, tempPath, false);
                ++i;
            }
            GTK.gtk_tree_path_free(tempPath);
        }
        if (scroll) {
            GdkRectangle cellRect = new GdkRectangle();
            GTK.gtk_widget_realize(this.handle);
            GTK.gtk_tree_view_get_cell_area(this.handle, path, 0, cellRect);
            boolean isHidden = cellRect.y == 0 && cellRect.height == 0;
            int[] tx = new int[1];
            int[] ty = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_tree_coords(this.handle, cellRect.x, cellRect.y, tx, ty);
            if (!isHidden) {
                GdkRectangle visibleRect = new GdkRectangle();
                GTK.gtk_tree_view_get_visible_rect(this.handle, visibleRect);
                if (ty[0] < visibleRect.y || ty[0] + cellRect.height > visibleRect.y + visibleRect.height) {
                    isHidden = true;
                }
            }
            if (isHidden) {
                GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0, depth != 1, 0.5f, 0.0f);
            }
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, true);
        GTK.gtk_tree_path_free(path);
    }

    @Override
    void updateScrollBarValue(ScrollBar bar) {
        super.updateScrollBarValue(bar);
        int parentHandle = this.parentingHandle();
        int list = GTK.gtk_container_get_children(parentHandle);
        if (list == 0) {
            return;
        }
        int temp = list;
        while (temp != 0) {
            int widget = OS.g_list_data(temp);
            if (widget != 0) {
                GTK.gtk_widget_queue_resize(widget);
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
    }

    @Override
    int windowProc(int handle, int arg0, int user_data) {
        switch (user_data) {
            case 18: {
                if (GTK.GTK_VERSION < OS.VERSION(3, 10, 0) || !this.hasChildren) break;
                this.propagateDraw(handle, arg0);
                break;
            }
            case 19: {
                Control control;
                int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0);
                if (itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null) break;
                GdkEventExpose gdkEvent = new GdkEventExpose();
                OS.memmove(gdkEvent, arg0, GdkEventExpose.sizeof);
                int window = GTK.gtk_tree_view_get_bin_window(handle);
                if (window != gdkEvent.window) break;
                this.drawBackground(control, window, gdkEvent.region, gdkEvent.area_x, gdkEvent.area_y, gdkEvent.area_width, gdkEvent.area_height);
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    @Override
    Point resizeCalculationsGTK3(int widget, int width, int height) {
        int hScrollBarHeight;
        Point sizes = super.resizeCalculationsGTK3(widget, width, height);
        if (widget == this.scrolledHandle && GTK.GTK_VERSION >= OS.VERSION(3, 14, 0) && this.getHeaderVisible() && (hScrollBarHeight = this.hScrollBarWidth()) > 0) {
            sizes.y = Math.max(sizes.y, this.getHeaderHeight() + hScrollBarHeight + this.getBorderWidth() * 2);
        }
        return sizes;
    }
}

