/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.NexusAccessor;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.TypeInitializer;
import net.bytebuddy.implementation.LoadedTypeInitializer;

public interface TypeResolutionStrategy {
    public Resolved resolve();

    public static class Active
    implements TypeResolutionStrategy {
        private final NexusAccessor nexusAccessor;

        public Active() {
            this(new NexusAccessor());
        }

        public Active(NexusAccessor nexusAccessor) {
            this.nexusAccessor = nexusAccessor;
        }

        @Override
        @SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="Avoid thread-contention")
        public net.bytebuddy.dynamic.TypeResolutionStrategy$Resolved resolve() {
            return new Resolved(this.nexusAccessor, new Random().nextInt());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Active)) {
                return false;
            }
            Active other = (Active)o;
            if (!other.canEqual(this)) {
                return false;
            }
            NexusAccessor this$nexusAccessor = this.nexusAccessor;
            NexusAccessor other$nexusAccessor = other.nexusAccessor;
            return !(this$nexusAccessor == null ? other$nexusAccessor != null : !((Object)this$nexusAccessor).equals(other$nexusAccessor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Active;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            NexusAccessor $nexusAccessor = this.nexusAccessor;
            result = result * 59 + ($nexusAccessor == null ? 43 : ((Object)$nexusAccessor).hashCode());
            return result;
        }

        protected static class Resolved
        implements net.bytebuddy.dynamic.TypeResolutionStrategy$Resolved {
            private final NexusAccessor nexusAccessor;
            private final int identification;

            protected Resolved(NexusAccessor nexusAccessor, int identification) {
                this.nexusAccessor = nexusAccessor;
                this.identification = identification;
            }

            @Override
            public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
                return typeInitializer.expandWith(new NexusAccessor.InitializationAppender(this.identification));
            }

            @Override
            public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
                HashMap<TypeDescription, LoadedTypeInitializer> loadedTypeInitializers = new HashMap<TypeDescription, LoadedTypeInitializer>(dynamicType.getLoadedTypeInitializers());
                TypeDescription instrumentedType = dynamicType.getTypeDescription();
                Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
                this.nexusAccessor.register(instrumentedType.getName(), types.get(instrumentedType).getClassLoader(), this.identification, (LoadedTypeInitializer)loadedTypeInitializers.remove(instrumentedType));
                for (Map.Entry entry : loadedTypeInitializers.entrySet()) {
                    ((LoadedTypeInitializer)entry.getValue()).onLoad(types.get(entry.getKey()));
                }
                return types;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Resolved)) {
                    return false;
                }
                Resolved other = (Resolved)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                NexusAccessor this$nexusAccessor = this.nexusAccessor;
                NexusAccessor other$nexusAccessor = other.nexusAccessor;
                if (this$nexusAccessor == null ? other$nexusAccessor != null : !((Object)this$nexusAccessor).equals(other$nexusAccessor)) {
                    return false;
                }
                return this.identification == other.identification;
            }

            protected boolean canEqual(Object other) {
                return other instanceof Resolved;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                NexusAccessor $nexusAccessor = this.nexusAccessor;
                result = result * 59 + ($nexusAccessor == null ? 43 : ((Object)$nexusAccessor).hashCode());
                result = result * 59 + this.identification;
                return result;
            }
        }
    }

    public static enum Disabled implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            throw new IllegalStateException("Cannot initialize a dynamic type for a disabled type resolution strategy");
        }
    }

    public static enum Lazy implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            return classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
        }
    }

    public static enum Passive implements TypeResolutionStrategy,
    Resolved
    {
        INSTANCE;


        @Override
        public Resolved resolve() {
            return this;
        }

        @Override
        public TypeInitializer injectedInto(TypeInitializer typeInitializer) {
            return typeInitializer;
        }

        @Override
        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType dynamicType, S classLoader, ClassLoadingStrategy<? super S> classLoadingStrategy) {
            Map<TypeDescription, Class<?>> types = classLoadingStrategy.load(classLoader, dynamicType.getAllTypes());
            for (Map.Entry<TypeDescription, LoadedTypeInitializer> entry : dynamicType.getLoadedTypeInitializers().entrySet()) {
                entry.getValue().onLoad(types.get(entry.getKey()));
            }
            return new HashMap(types);
        }
    }

    public static interface Resolved {
        public TypeInitializer injectedInto(TypeInitializer var1);

        public <S extends ClassLoader> Map<TypeDescription, Class<?>> initialize(DynamicType var1, S var2, ClassLoadingStrategy<? super S> var3);
    }
}

