/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

public interface ElementMatcher<T> {
    public boolean matches(T var1);

    public static interface Junction<S>
    extends ElementMatcher<S> {
        public <U extends S> Junction<U> and(ElementMatcher<? super U> var1);

        public <U extends S> Junction<U> or(ElementMatcher<? super U> var1);

        public static abstract class AbstractBase<V>
        implements Junction<V> {
            @Override
            public <U extends V> Junction<U> and(ElementMatcher<? super U> other) {
                return new Conjunction<U>(this, other);
            }

            @Override
            public <U extends V> Junction<U> or(ElementMatcher<? super U> other) {
                return new Disjunction<U>(this, other);
            }
        }

        public static class Conjunction<W>
        extends AbstractBase<W> {
            private final ElementMatcher<? super W> left;
            private final ElementMatcher<? super W> right;

            public Conjunction(ElementMatcher<? super W> left, ElementMatcher<? super W> right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(W target) {
                return this.left.matches(target) && this.right.matches(target);
            }

            public String toString() {
                return "(" + this.left + " and " + this.right + ')';
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Conjunction)) {
                    return false;
                }
                Conjunction other = (Conjunction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ElementMatcher<W> this$left = this.left;
                ElementMatcher<? super W> other$left = other.left;
                if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                    return false;
                }
                ElementMatcher<W> this$right = this.right;
                ElementMatcher<? super W> other$right = other.right;
                return !(this$right == null ? other$right != null : !this$right.equals(other$right));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Conjunction;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ElementMatcher<W> $left = this.left;
                result = result * 59 + ($left == null ? 43 : $left.hashCode());
                ElementMatcher<W> $right = this.right;
                result = result * 59 + ($right == null ? 43 : $right.hashCode());
                return result;
            }
        }

        public static class Disjunction<W>
        extends AbstractBase<W> {
            private final ElementMatcher<? super W> left;
            private final ElementMatcher<? super W> right;

            public Disjunction(ElementMatcher<? super W> left, ElementMatcher<? super W> right) {
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(W target) {
                return this.left.matches(target) || this.right.matches(target);
            }

            public String toString() {
                return "(" + this.left + " or " + this.right + ')';
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Disjunction)) {
                    return false;
                }
                Disjunction other = (Disjunction)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ElementMatcher<W> this$left = this.left;
                ElementMatcher<? super W> other$left = other.left;
                if (this$left == null ? other$left != null : !this$left.equals(other$left)) {
                    return false;
                }
                ElementMatcher<W> this$right = this.right;
                ElementMatcher<? super W> other$right = other.right;
                return !(this$right == null ? other$right != null : !this$right.equals(other$right));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Disjunction;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ElementMatcher<W> $left = this.left;
                result = result * 59 + ($left == null ? 43 : $left.hashCode());
                ElementMatcher<W> $right = this.right;
                result = result * 59 + ($right == null ? 43 : $right.hashCode());
                return result;
            }
        }
    }
}

