/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.io.File;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String filterPath = "";
    String fileName = "";
    String[] fileNames = new String[0];
    String fullPath = "";
    int filterIndex = -1;
    boolean overwrite = false;
    boolean uriMode;
    long handle;
    static final char SEPARATOR = File.separatorChar;
    static final char EXTENSION_SEPARATOR = ';';
    static final char FILE_EXTENSION_SEPARATOR = '.';
    private static final int PATH_MAX = 1024;

    public FileDialog(Shell parent) {
        this(parent, 65536);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, FileDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    String computeResultChooserDialog() {
        long filterNamePtr;
        this.fullPath = null;
        if ((this.style & 2) != 0) {
            long list = 0L;
            list = this.uriMode ? GTK.gtk_file_chooser_get_uris(this.handle) : GTK.gtk_file_chooser_get_filenames(this.handle);
            int listLength = OS.g_slist_length(list);
            this.fileNames = new String[listLength];
            long current = list;
            int writePos = 0;
            int i = 0;
            while (i < listLength) {
                long name = OS.g_slist_data(current);
                long utf8Ptr = 0L;
                if (this.uriMode) {
                    utf8Ptr = name;
                } else {
                    utf8Ptr = OS.g_filename_to_utf8(name, -1L, null, null, null);
                    if (utf8Ptr == 0L) {
                        utf8Ptr = OS.g_filename_display_name(name);
                    }
                }
                if (name != utf8Ptr) {
                    OS.g_free(name);
                }
                if (utf8Ptr != 0L) {
                    long[] items_written = new long[1];
                    long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                    OS.g_free(utf8Ptr);
                    if (utf16Ptr != 0L) {
                        int clength = (int)items_written[0];
                        char[] chars = new char[clength];
                        C.memmove(chars, utf16Ptr, (long)(clength * 2));
                        OS.g_free(utf16Ptr);
                        this.fullPath = new String(chars);
                        this.fileNames[writePos++] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                    }
                }
                current = OS.g_slist_next(current);
                ++i;
            }
            if (writePos != 0 && writePos != listLength) {
                String[] validFileNames = new String[writePos];
                System.arraycopy(this.fileNames, 0, validFileNames, 0, writePos);
                this.fileNames = validFileNames;
            }
            OS.g_slist_free(list);
        } else {
            long utf8Ptr = 0L;
            if (this.uriMode) {
                utf8Ptr = GTK.gtk_file_chooser_get_uri(this.handle);
            } else {
                long path = GTK.gtk_file_chooser_get_filename(this.handle);
                if (path != 0L) {
                    utf8Ptr = OS.g_filename_to_utf8(path, -1L, null, null, null);
                    if (utf8Ptr == 0L) {
                        utf8Ptr = OS.g_filename_display_name(path);
                    }
                    if (path != utf8Ptr) {
                        OS.g_free(path);
                    }
                }
            }
            if (utf8Ptr != 0L) {
                long[] items_written = new long[1];
                long utf16Ptr = OS.g_utf8_to_utf16(utf8Ptr, -1L, null, items_written, null);
                OS.g_free(utf8Ptr);
                if (utf16Ptr != 0L) {
                    int clength = (int)items_written[0];
                    char[] chars = new char[clength];
                    C.memmove(chars, utf16Ptr, (long)(clength * 2));
                    OS.g_free(utf16Ptr);
                    this.fullPath = new String(chars);
                    this.fileNames = new String[1];
                    this.fileNames[0] = this.fullPath.substring(this.fullPath.lastIndexOf(SEPARATOR) + 1);
                }
            }
        }
        this.filterIndex = -1;
        long filter = GTK.gtk_file_chooser_get_filter(this.handle);
        if (filter != 0L && (filterNamePtr = GTK.gtk_file_filter_get_name(filter)) != 0L) {
            int length = C.strlen(filterNamePtr);
            byte[] buffer = new byte[length];
            C.memmove(buffer, filterNamePtr, (long)length);
            String filterName = new String(Converter.mbcsToWcs(buffer));
            int i = 0;
            while (i < this.filterExtensions.length) {
                if (this.filterNames.length > 0) {
                    if (this.filterNames[i].equals(filterName)) {
                        this.filterIndex = i;
                        break;
                    }
                } else if (this.filterExtensions[i].equals(filterName)) {
                    this.filterIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (this.fullPath != null) {
            int separatorIndex = this.fullPath.lastIndexOf(SEPARATOR);
            this.fileName = this.fullPath.substring(separatorIndex + 1);
            this.filterPath = this.fullPath.substring(0, separatorIndex);
        }
        return this.fullPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        return this.openChooserDialog();
    }

    String openChooserDialog() {
        byte[] titleBytes = Converter.wcsToMbcs(this.title, true);
        int action = (this.style & 0x2000) != 0 ? 1 : 0;
        long shellHandle = this.parent.topHandle();
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.handle = display.getDismissalAlignment() == 131072 ? GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, action, GTK.GTK_NAMED_LABEL_CANCEL, -6, GTK.GTK_NAMED_LABEL_OK, -5, 0L) : GTK.gtk_file_chooser_dialog_new(titleBytes, shellHandle, action, GTK.GTK_NAMED_LABEL_OK, -5, GTK.GTK_NAMED_LABEL_CANCEL, -6, 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        GTK.gtk_window_set_modal(this.handle, true);
        long group = GTK.gtk_window_get_group(0L);
        GTK.gtk_window_group_add_window(group, this.handle);
        long pixbufs = GTK.gtk_window_get_icon_list(shellHandle);
        if (pixbufs != 0L) {
            GTK.gtk_window_set_icon_list(this.handle, pixbufs);
            OS.g_list_free(pixbufs);
        }
        if (this.uriMode) {
            GTK.gtk_file_chooser_set_local_only(this.handle, false);
        }
        this.presetChooserDialog();
        display.addIdleProc();
        String answer = null;
        Dialog oldModal = null;
        if (GTK.gtk_window_get_modal(this.handle)) {
            oldModal = display.getModalDialog();
            display.setModalDialog(this);
        }
        int signalId = 0;
        long hookId = 0L;
        if ((this.style & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, GTK.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, display.emissionProc, this.handle, 0L);
        }
        display.sendPreExternalEventDispatchEvent();
        int response = GTK.gtk_dialog_run(this.handle);
        GDK.gdk_threads_leave();
        display.sendPostExternalEventDispatchEvent();
        if ((this.style & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (GTK.gtk_window_get_modal(this.handle)) {
            display.setModalDialog(oldModal);
        }
        if (response == -5) {
            answer = this.computeResultChooserDialog();
        }
        display.removeIdleProc();
        GTK.gtk_widget_destroy(this.handle);
        return answer;
    }

    void presetChooserDialog() {
        byte[] buffer;
        long ptr;
        if ((this.style & 0x2002) == 2) {
            GTK.gtk_file_chooser_set_select_multiple(this.handle, true);
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if (this.fileName == null) {
            this.fileName = "";
        }
        if ((this.style & 0x2000) != 0) {
            if (this.fileName.equals("")) {
                this.fileName = "Untitled";
            }
            if (this.filterPath.length() > 0) {
                byte[] buffer2;
                if (this.uriMode) {
                    buffer2 = Converter.wcsToMbcs(this.filterPath, true);
                    GTK.gtk_file_chooser_set_current_folder_uri(this.handle, buffer2);
                } else {
                    buffer2 = Converter.wcsToMbcs(String.valueOf(SEPARATOR) + this.filterPath, true);
                    if (OS.IsAIX) {
                        byte[] outputBuffer = new byte[1024];
                        ptr = OS.realpath(buffer2, outputBuffer);
                        if (ptr != 0L) {
                            GTK.gtk_file_chooser_set_current_folder(this.handle, ptr);
                        }
                    } else {
                        long ptr2 = OS.realpath(buffer2, null);
                        if (ptr2 != 0L) {
                            GTK.gtk_file_chooser_set_current_folder(this.handle, ptr2);
                            OS.g_free(ptr2);
                        }
                    }
                }
            }
            if (this.fileName.length() > 0) {
                StringBuilder filenameWithExt = new StringBuilder();
                filenameWithExt.append(this.fileName);
                if (this.fileName.lastIndexOf(46) == -1 && this.filterExtensions.length != 0) {
                    int separatorIndex;
                    String selectedFilter = null;
                    selectedFilter = this.filterIndex == -1 ? this.filterExtensions[0] : this.filterExtensions[this.filterIndex];
                    String extFilter = null;
                    int index = selectedFilter.indexOf(59);
                    extFilter = index == -1 ? selectedFilter.trim() : selectedFilter.substring(0, index).trim();
                    String extension = extFilter.substring(separatorIndex = extFilter.lastIndexOf(46));
                    if (!this.isGlobPattern(extension)) {
                        filenameWithExt.append(extension);
                    }
                }
                buffer = Converter.wcsToMbcs(filenameWithExt.toString(), true);
                GTK.gtk_file_chooser_set_current_name(this.handle, buffer);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.filterPath.length() > 0) {
                if (!this.uriMode) {
                    stringBuilder.append(SEPARATOR);
                }
                stringBuilder.append(this.filterPath);
                stringBuilder.append(SEPARATOR);
            }
            if (this.fileName.length() > 0) {
                stringBuilder.append(this.fileName);
            }
            buffer = Converter.wcsToMbcs(stringBuilder.toString(), true);
            if (this.uriMode) {
                GTK.gtk_file_chooser_set_uri(this.handle, buffer);
            } else if (OS.IsAIX) {
                byte[] outputBuffer = new byte[1024];
                long ptr3 = OS.realpath(buffer, outputBuffer);
                if (ptr3 != 0L) {
                    if (this.fileName.length() > 0) {
                        GTK.gtk_file_chooser_set_filename(this.handle, ptr3);
                    } else {
                        GTK.gtk_file_chooser_set_current_folder(this.handle, ptr3);
                    }
                }
            } else {
                ptr = OS.realpath(buffer, null);
                if (ptr != 0L) {
                    if (this.fileName.length() > 0) {
                        GTK.gtk_file_chooser_set_filename(this.handle, ptr);
                    } else {
                        GTK.gtk_file_chooser_set_current_folder(this.handle, ptr);
                    }
                    OS.g_free(ptr);
                }
            }
        }
        if ((this.style & 0x2000) != 0) {
            GTK.gtk_file_chooser_set_do_overwrite_confirmation(this.handle, this.overwrite);
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        long initialFilter = 0L;
        int i = 0;
        while (i < this.filterExtensions.length) {
            if (this.filterExtensions[i] != null) {
                byte[] filterString;
                String current;
                byte[] name;
                long filter = GTK.gtk_file_filter_new();
                if (this.filterNames.length > i && this.filterNames[i] != null) {
                    name = Converter.wcsToMbcs(this.filterNames[i], true);
                    GTK.gtk_file_filter_set_name(filter, name);
                } else {
                    name = Converter.wcsToMbcs(this.filterExtensions[i], true);
                    GTK.gtk_file_filter_set_name(filter, name);
                }
                int start = 0;
                int index = this.filterExtensions[i].indexOf(59);
                while (index != -1) {
                    current = this.filterExtensions[i].substring(start, index);
                    filterString = Converter.wcsToMbcs(current, true);
                    GTK.gtk_file_filter_add_pattern(filter, filterString);
                    start = index + 1;
                    index = this.filterExtensions[i].indexOf(59, start);
                }
                current = this.filterExtensions[i].substring(start);
                filterString = Converter.wcsToMbcs(current, true);
                GTK.gtk_file_filter_add_pattern(filter, filterString);
                GTK.gtk_file_chooser_add_filter(this.handle, filter);
                if (i == this.filterIndex) {
                    initialFilter = filter;
                }
            }
            ++i;
        }
        if (initialFilter != 0L) {
            GTK.gtk_file_chooser_set_filter(this.handle, initialFilter);
        }
        this.fullPath = null;
        this.fileNames = new String[0];
    }

    private boolean isGlobPattern(String extension) {
        return extension.contains("*") || extension.contains("?") || extension.contains("[") && extension.contains("]");
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterIndex(int index) {
        this.filterIndex = index;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    void setURIMode(boolean uriMode) {
        this.uriMode = uriMode;
    }
}

