/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.e4.migration.ApplicationBuilder;
import org.eclipse.ui.internal.e4.migration.IModelBuilderFactory;
import org.eclipse.ui.internal.e4.migration.ModelBuilderFactoryImpl;
import org.eclipse.ui.internal.e4.migration.WorkbenchMementoReader;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.views.IStickyViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class WorkbenchMigrationProcessor {
    @Inject
    private MApplication application;
    @Inject
    private IEclipseContext context;
    @Inject
    private EModelService modelService;
    private IMemento workbenchMemento;
    private File legacyWorkbenchFile;
    private boolean migrated;
    private List<MWindow> defaultWindows;

    public boolean isLegacyWorkbenchDetected() {
        this.legacyWorkbenchFile = this.getLegacyWorkbenchFile();
        return this.legacyWorkbenchFile != null && this.legacyWorkbenchFile.exists();
    }

    public void migrate() {
        if (!this.isLegacyWorkbenchDetected()) {
            return;
        }
        this.workbenchMemento = this.loadMemento();
        if (this.workbenchMemento == null) {
            return;
        }
        this.defaultWindows = new ArrayList<MWindow>(this.application.getChildren());
        this.application.getChildren().clear();
        IEclipseContext builderContext = this.context.createChild();
        IModelBuilderFactory builderFactory = (IModelBuilderFactory)ContextInjectionFactory.make(ModelBuilderFactoryImpl.class, (IEclipseContext)builderContext);
        builderContext.set(IModelBuilderFactory.class, (Object)builderFactory);
        ApplicationBuilder modelBuilder = builderFactory.createApplicationBuilder(new WorkbenchMementoReader(this.workbenchMemento));
        modelBuilder.createApplication();
        this.context.remove("NO_SAVED_MODEL_FOUND");
        PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
        this.migrated = true;
    }

    private IMemento loadMemento() {
        XMLMemento memento = null;
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.legacyWorkbenchFile), StandardCharsets.UTF_8));){
                memento = XMLMemento.createReadRoot(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | WorkbenchException e) {
            WorkbenchPlugin.log("Failed to load " + this.legacyWorkbenchFile.getAbsolutePath(), (Throwable)e);
        }
        return memento;
    }

    private File getLegacyWorkbenchFile() {
        if (this.legacyWorkbenchFile == null) {
            IPath path = WorkbenchPlugin.getDefault().getDataLocation();
            if (path == null) {
                return null;
            }
            path = path.append("workbench.xml");
            this.legacyWorkbenchFile = path.toFile();
        }
        return this.legacyWorkbenchFile;
    }

    public boolean isWorkbenchMigrated() {
        return this.migrated;
    }

    public void updatePartsAfterMigration(IPerspectiveRegistry perspectiveRegistry, IViewRegistry viewRegistry) {
        if (!this.migrated) {
            return;
        }
        for (MPartDescriptor desc : this.application.getDescriptors()) {
            for (MPart part : this.modelService.findElements((MUIElement)this.application, desc.getElementId(), MPart.class, null)) {
                if (part.getLabel() == null) {
                    part.setLabel(desc.getLocalizedLabel());
                }
                if (part.getTooltip() == null) {
                    part.setTooltip(desc.getLocalizedTooltip());
                }
                if (part.getIconURI() == null) {
                    part.setIconURI(desc.getIconURI());
                }
                part.setCloseable(desc.isCloseable());
            }
        }
        for (MPerspective persp : this.modelService.findElements((MUIElement)this.application, null, MPerspective.class, null)) {
            this.setPerspectiveIcon(perspectiveRegistry, persp);
        }
        for (MUIElement snippet : this.application.getSnippets()) {
            if (!(snippet instanceof MPerspective)) continue;
            this.setPerspectiveIcon(perspectiveRegistry, (MPerspective)snippet);
        }
        IStickyViewDescriptor[] stickyViews = viewRegistry.getStickyViews();
        for (MWindow window : this.application.getChildren()) {
            this.moveStickyViews(stickyViews, window);
        }
    }

    private void moveStickyViews(IStickyViewDescriptor[] stickyViews, MWindow window) {
        IStickyViewDescriptor[] iStickyViewDescriptorArray = stickyViews;
        int n = stickyViews.length;
        int n2 = 0;
        while (n2 < n) {
            IStickyViewDescriptor stickyView = iStickyViewDescriptorArray[n2];
            this.removeStickyViewFromPerspectives(stickyView, window);
            ++n2;
        }
        for (MPartStack stickyFolder : this.modelService.findElements((MUIElement)this.application, "stickyFolderRight", MPartStack.class, null)) {
            this.fillStickyFolder(stickyViews, stickyFolder);
        }
    }

    private void removeStickyViewFromPerspectives(IStickyViewDescriptor stickyView, MWindow window) {
        for (MPlaceholder placeholder : this.modelService.findElements((MUIElement)window, stickyView.getId(), MPlaceholder.class, null)) {
            MElementContainer parent = placeholder.getParent();
            if ("stickyFolderRight".equals(parent.getElementId())) continue;
            placeholder.setToBeRendered(false);
            placeholder.setVisible(false);
            parent.getChildren().remove(placeholder);
            if (parent.getChildren().isEmpty()) {
                parent.getParent().getChildren().remove(parent);
                continue;
            }
            if (parent.getSelectedElement() != placeholder) continue;
            parent.setSelectedElement(null);
        }
    }

    private void fillStickyFolder(IStickyViewDescriptor[] stickyViews, MPartStack stickyFolder) {
        IStickyViewDescriptor[] iStickyViewDescriptorArray = stickyViews;
        int n = stickyViews.length;
        int n2 = 0;
        while (n2 < n) {
            IStickyViewDescriptor stickyView = iStickyViewDescriptorArray[n2];
            this.addPartToStickyFolder(stickyView.getId(), stickyFolder);
            ++n2;
        }
    }

    private void setPerspectiveIcon(IPerspectiveRegistry perspectiveRegistry, MPerspective perspective) {
        IPerspectiveDescriptor orgPerspDescr;
        String perspId = perspective.getElementId();
        if (perspective.getTransientData().containsKey("originalId")) {
            perspId = (String)perspective.getTransientData().get("originalId");
        }
        if ((orgPerspDescr = perspectiveRegistry.findPerspectiveWithId(perspId)) != null) {
            perspective.setIconURI(MenuHelper.getIconURI(orgPerspDescr.getImageDescriptor(), this.context));
        }
    }

    private MPlaceholder addPartToStickyFolder(String partId, MPartStack stickyFolder) {
        MPart part = null;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)stickyFolder);
        for (MUIElement element : window.getSharedElements()) {
            if (!element.getElementId().equals(partId)) continue;
            part = (MPart)element;
            break;
        }
        if (part == null) {
            part = (MPart)this.modelService.createModelElement(MPart.class);
            part.setElementId(partId);
            part.setContributionURI("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView");
            part.getTags().add("View");
            window.getSharedElements().add(part);
        }
        MPlaceholder placeholder = null;
        placeholder = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholder.setElementId(partId);
        placeholder.setRef((MUIElement)part);
        placeholder.setToBeRendered(false);
        part.setCurSharedRef(placeholder);
        stickyFolder.getChildren().add(placeholder);
        return placeholder;
    }

    public void restoreDefaultModel() {
        this.application.getTags().clear();
        this.application.getPersistedState().clear();
        this.application.getSnippets().clear();
        this.application.getDescriptors().clear();
        this.application.getChildren().clear();
        this.application.getChildren().addAll(this.defaultWindows);
    }
}

