/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchMessages;

public class DirectoryProposalContentAssist {
    private Path lastDir;
    private DirectoryProposalAutoCompleteField autoCompleteField;
    private Combo directoryCombo;
    private boolean popupActivated = false;
    private List<CompletableFuture<Void>> proposalUpdateFutures = Collections.synchronizedList(new ArrayList());

    public void apply(Combo combo) {
        this.directoryCombo = combo;
        this.autoCompleteField = new DirectoryProposalAutoCompleteField((Control)this.directoryCombo, (IControlContentAdapter)new ComboContentAdapter());
        this.getContentProposalAdapter().addContentProposalListener(e -> this.updateProposals(this.directoryCombo.getText(), false));
        this.getContentProposalAdapter().addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                DirectoryProposalContentAssist.this.popupActivated = true;
            }

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
            }
        });
        this.directoryCombo.addVerifyListener(e -> {
            boolean openProposalPopup = true;
            if (e.text.length() > 1) {
                openProposalPopup = false;
            }
            this.updateProposals(this.directoryCombo.getText().substring(0, this.directoryCombo.getCaretPosition()), openProposalPopup);
        });
        this.directoryCombo.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 27) {
                this.popupActivated = false;
            }
        }));
        this.directoryCombo.addKeyListener(KeyListener.keyReleasedAdapter(e -> {
            if (this.isTraverse((KeyEvent)e)) {
                int caretPosition = this.directoryCombo.getCaretPosition();
                this.updateProposals(this.directoryCombo.getText().substring(0, caretPosition), this.popupActivated);
            }
        }));
        this.directoryCombo.addMouseListener(MouseListener.mouseUpAdapter(e -> {
            int caretPosition = ((Combo)e.getSource()).getCaretPosition();
            this.updateProposals(this.directoryCombo.getText().substring(0, caretPosition), false);
        }));
    }

    private boolean isTraverse(KeyEvent e) {
        return e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008;
    }

    private void updateProposals(String textFromCombo, boolean openProposalPopup) {
        Path dir = this.pathWithoutFileName(textFromCombo);
        if (dir != null && dir.equals(this.lastDir)) {
            if (openProposalPopup) {
                this.autoCompleteField.adapter.openProposalPopup();
            }
            return;
        }
        if (dir == null || !this.safeIsDirectory(dir)) {
            this.updateProposals(Collections.emptyList(), false);
            this.lastDir = null;
            return;
        }
        this.lastDir = dir;
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> this.updateProposals(this.retrieveDirectoriesIn(dir), openProposalPopup));
        this.proposalUpdateFutures.add(completableFuture);
        this.proposalUpdateFutures.removeIf(CompletableFuture::isDone);
    }

    private List<String> retrieveDirectoriesIn(Path dir) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> files = Files.list(dir);){
                return this.filterPaths(files).sorted().collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return new ArrayList<String>();
        }
    }

    private void updateProposals(List<String> proposals, boolean openProposalPopup) {
        this.directoryCombo.getDisplay().syncExec(() -> this.autoCompleteField.refreshProposals(proposals, openProposalPopup));
    }

    private Path pathWithoutFileName(String inputPath) {
        int lastIndex = inputPath.lastIndexOf(File.separatorChar);
        if (this.separatorNotFound(lastIndex)) {
            return null;
        }
        return this.safeGetPath(this.removeFileName(inputPath, lastIndex));
    }

    private boolean separatorNotFound(int lastIndex) {
        return lastIndex < 0;
    }

    private String removeFileName(String text, int lastIndex) {
        if (lastIndex == 0) {
            return File.separator;
        }
        return text.substring(0, lastIndex + 1);
    }

    private Path safeGetPath(String text) {
        try {
            return Paths.get(text, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
    }

    private boolean safeIsDirectory(Path dir) {
        try {
            return dir.toFile().isDirectory();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private Stream<String> filterPaths(Stream<Path> paths) {
        return paths.filter(path -> {
            try {
                return this.safeIsDirectory((Path)path) && !Files.isHidden(path);
            }
            catch (IOException iOException) {
                return false;
            }
        }).map(path -> String.valueOf(path.toString()) + File.separator);
    }

    public DirectoryProposalAutoCompleteField getAutoCompleteField() {
        return this.autoCompleteField;
    }

    public ContentProposalAdapter getContentProposalAdapter() {
        return this.autoCompleteField.adapter;
    }

    protected void wait(int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture.allOf(this.proposalUpdateFutures.toArray(new CompletableFuture[this.proposalUpdateFutures.size()])).get(timeout, TimeUnit.MILLISECONDS);
    }

    private class DirectoryProposalAutoCompleteField {
        private FileNameSubstringMatchContentProposalProvider proposalProvider = new FileNameSubstringMatchContentProposalProvider();
        private OpenableContentProposalAdapter adapter;

        public DirectoryProposalAutoCompleteField(Control control, IControlContentAdapter controlContentAdapter) {
            KeyStroke triggeringKeyStroke = this.safeKeyStroke("Ctrl+Space");
            String backspace = "\b";
            String delete = "\u007f";
            char[] autoactivationChars = ("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789" + backspace + delete).toCharArray();
            this.adapter = new OpenableContentProposalAdapter(control, controlContentAdapter, this.proposalProvider, triggeringKeyStroke, autoactivationChars);
            this.adapter.setPropagateKeys(true);
            this.adapter.setProposalAcceptanceStyle(2);
        }

        private KeyStroke safeKeyStroke(String keyStrokePattern) {
            try {
                return KeyStroke.getInstance((String)keyStrokePattern);
            }
            catch (ParseException parseException) {
                return null;
            }
        }

        public void refreshProposals(List<String> proposals, boolean openProposalPopup) {
            this.proposalProvider.setProposals(proposals);
            this.adapter.refresh();
            if (openProposalPopup) {
                this.adapter.openProposalPopup();
            }
        }
    }

    private static class FileNameSubstringMatchContentProposalProvider
    implements IContentProposalProvider {
        private List<String> proposals = Collections.emptyList();

        private FileNameSubstringMatchContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            if (position == 0) {
                return new IContentProposal[0];
            }
            String substring = contents.substring(0, position);
            Pattern pattern = Pattern.compile(substring, 82);
            return (IContentProposal[])this.proposals.stream().filter(proposal -> proposal.length() >= substring.length() && pattern.matcher((CharSequence)proposal).find()).map(ContentProposal::new).toArray(IContentProposal[]::new);
        }

        public void setProposals(List<String> proposals) {
            this.proposals = proposals;
        }
    }

    private static class OpenableContentProposalAdapter
    extends ContentProposalAdapter {
        private static final String CONTENT_ASSIST_DECORATION_ID = "org.eclipse.ui.internal.ide.DirectoryProposalContentAssist$ReopenableContentProposalAdapter";

        public OpenableContentProposalAdapter(Control control, IControlContentAdapter controlContentAdapter, IContentProposalProvider proposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
            super(control, controlContentAdapter, proposalProvider, keyStroke, autoActivationCharacters);
            this.installContentProposalFieldDecoration(control, keyStroke);
        }

        private void installContentProposalFieldDecoration(Control control, KeyStroke keyStroke) {
            ControlDecoration decoration = new ControlDecoration(control, 16512);
            decoration.setShowOnlyOnFocus(true);
            FieldDecoration dec = this.getContentAssistFieldDecoration(keyStroke);
            decoration.setImage(dec.getImage());
            decoration.setDescriptionText(dec.getDescription());
        }

        private FieldDecoration getContentAssistFieldDecoration(KeyStroke keyStroke) {
            String decId;
            FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
            FieldDecoration dec = registry.getFieldDecoration(decId = CONTENT_ASSIST_DECORATION_ID + keyStroke);
            if (dec == null) {
                FieldDecoration originalDec = registry.getFieldDecoration("DEC_CONTENT_PROPOSAL");
                registry.registerFieldDecoration(decId, null, originalDec.getImage());
                dec = registry.getFieldDecoration(decId);
            }
            dec.setDescription(NLS.bind((String)WorkbenchMessages.ContentAssist_Cue_Description_Key, (Object)keyStroke));
            return dec;
        }

        public void openProposalPopup() {
            super.openProposalPopup();
        }
    }
}

