/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.ExpressionMatchQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.wst.server.discovery.internal.Activator;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.model.IServerExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionUpdateSite {
    private static final List<String> EMPTY_LIST = new ArrayList<String>(0);
    public static final String SERVER_ADAPTER_ID = "org.eclipse.wst.server.core.serverAdapter";
    private String url;
    private String featureId;
    private List<String> categories;

    public ExtensionUpdateSite() {
    }

    public ExtensionUpdateSite(String url, String featureId, List<String> categories) {
        this.url = url;
        this.featureId = featureId;
        this.categories = categories;
    }

    public String getUrl() {
        return this.url;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public List<String> getCategories() {
        if (this.categories == null) {
            return EMPTY_LIST;
        }
        return this.categories;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IServerExtension> getExtensions(IProgressMonitor monitor) throws CoreException, ProvisionException {
        url2 = null;
        manager = null;
        agent = null;
        list = new ArrayList<IServerExtension>();
        existingSites = null;
        try {
            bd = Activator.getDefault().getBundle().getBundleContext();
            agent = ExtensionUtility.getAgent(bd);
            url2 = new URI(this.url);
            mrf = new UpdateSiteMetadataRepositoryFactory();
            mrf.setAgent(ExtensionUtility.getAgent(bd));
            manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            existingSitesAll = manager.getKnownRepositories(0);
            existingSitesDisabled = manager.getKnownRepositories(8);
            existingSitesAllLen = existingSitesAll == null ? 0 : existingSitesAll.length;
            existingSitesDisabledLen = existingSitesDisabled == null ? 0 : existingSitesDisabled.length;
            existingSites = new URI[existingSitesAllLen + existingSitesDisabledLen];
            if (existingSitesAllLen > 0) {
                System.arraycopy(existingSitesAll, 0, existingSites, 0, existingSitesAllLen);
            }
            if (existingSitesDisabledLen > 0) {
                System.arraycopy(existingSitesDisabled, 0, existingSites, existingSitesAllLen, existingSitesDisabledLen);
            }
            try {
                repo = mrf.load(url2, 0, monitor);
                query = QueryUtil.createMatchQuery((String)"id ~=/*org.eclipse.wst.server.core.serverAdapter/", (Object[])new Object[0]);
                list = this.getInstallableUnits(repo, (IQuery<IInstallableUnit>)query, url2, monitor);
            }
            catch (ProvisionException pe) {
                Trace.trace((byte)2, "Error getting update site information", pe);
            }
            if (list.isEmpty()) {
                manager.addRepository(url2);
                query = QueryUtil.createIUAnyQuery();
                repo = manager.loadRepository(url2, monitor);
                list2 = this.getInstallableUnits(repo, (IQuery<IInstallableUnit>)query, url2, monitor);
                size = list2.size();
                i = 0;
                while (i < size) {
                    e = (Extension)list2.get(i);
                    iuArr = e.getIUs();
                    if (iuArr != null && iuArr.length > 0 && iuArr[0] != null && iuArr[0].getProperty("org.eclipse.wst.server.core.serverAdapter") != null) {
                        list.add(e);
                    }
                    ++i;
                }
            }
            if (list.isEmpty()) {
                manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
                manager.addRepository(url2);
                query = QueryUtil.createMatchQuery((String)"id ~=/*org.eclipse.wst.server.core.serverAdapter/", (Object[])new Object[0]);
                repo = manager.loadRepository(url2, monitor);
                list = this.getInstallableUnits(repo, (IQuery<IInstallableUnit>)query, url2, monitor);
            }
            var21_23 = list;
            return var21_23;
        }
        catch (ProvisionException e) {
            Trace.trace((byte)2, "Error getting update info", e);
            throw e;
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Error getting update info", e);
            var21_24 = new ArrayList<IServerExtension>(0);
            return var21_24;
        }
        finally {
            if (url2 == null) return var21_24;
            if (url2.getPath().length() == 0) return var21_24;
            if (manager == null) return var21_24;
            if (existingSites == null) return var21_24;
            if (existingSites.length <= 0) return var21_24;
            urlExists = false;
            var26_29 = existingSites;
            var25_32 = existingSites.length;
            var24_35 = 0;
            ** while (var24_35 < var25_32)
        }
lbl-1000:
        // 1 sources

        {
            uri = var26_29[var24_35];
            if (uri.getPath().equals(url2.getPath())) {
                urlExists = true;
                break;
            }
            ++var24_35;
            continue;
        }
lbl76:
        // 2 sources

        if (urlExists != false) return var21_24;
        manager.removeRepository(url2);
        return var21_24;
    }

    protected List<IServerExtension> getInstallableUnits(IMetadataRepository repo, IQuery<IInstallableUnit> query, URI url, IProgressMonitor monitor) {
        ArrayList<IServerExtension> list = new ArrayList<IServerExtension>();
        IQueryResult collector = repo.query(query, monitor);
        for (IInstallableUnit iu : collector.toUnmodifiableSet()) {
            Collection req = iu.getRequirements();
            if (req == null) continue;
            for (IRequirement requirement : req) {
                IMatchExpression matches = requirement.getMatches();
                query = new ExpressionMatchQuery(IInstallableUnit.class, (IExpression)matches, new Object[0]);
                IQueryResult collector2 = repo.query((IQuery)query, monitor);
                for (IInstallableUnit iu2 : collector2) {
                    if (list.contains(iu2)) continue;
                    Extension ext = new Extension(iu2, url);
                    list.add(ext);
                }
            }
        }
        return list;
    }
}

