/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.swt.test.ui.editor.EditorState;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class EditorBarTest {
    private static String projectName = "EditorBarTest-test";

    @Before
    public void prepare() {
        new WorkbenchShell();
        new ShellMenuItem(new String[]{"File", "New", "Other..."}).select();
        new DefaultShell("New");
        new DefaultTreeItem(new String[]{"General", "Project"}).select();
        new PushButton("Next >").click();
        DefaultShell projectShell = new DefaultShell("New Project");
        new LabeledText("Project name:").setText(projectName);
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)projectShell), TimePeriod.LONG);
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.selectProjects(new String[]{projectName});
        new ShellMenuItem(new String[]{"File", "New", "File"}).select();
        DefaultShell fileShell = new DefaultShell("New File");
        new LabeledText("File name:").setText("test.tlb");
        new PushButton("Finish").click();
        new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)fileShell));
        new DefaultEditor("editor-with-toolbar");
    }

    @After
    public void deleteProject() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)pe.getProject(projectName), (boolean)true);
    }

    @Test
    public void workbenchToolBarTest() {
        DefaultToolItem ti = new DefaultToolItem("Execute task");
        ti.click();
        Assert.assertTrue((String)"ToolItem was not clicked", (boolean)EditorState.isExecuted());
    }
}

