/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.plugin.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryOverrideRegistryReader
extends RegistryReader {
    static final String TAG_FACTORY = "factory";
    static final String ATT_URI = "uri";
    static final String ATT_CLASS = "class";
    static final String ATT_PREDECESSOR = "predecessor";
    private static final Comparator<IConfigurationElement> CONFIGURATION_ELEMENT_COMPARATOR = new Comparator<IConfigurationElement>(){

        @Override
        public int compare(IConfigurationElement element1, IConfigurationElement element2) {
            boolean element2Succeeds;
            String class1 = element1.getAttribute(FactoryOverrideRegistryReader.ATT_CLASS);
            String class2 = element2.getAttribute(FactoryOverrideRegistryReader.ATT_CLASS);
            boolean element1Succeeds = FactoryOverrideRegistryReader.getPredecessors(element1).contains(class2);
            if (element1Succeeds == (element2Succeeds = FactoryOverrideRegistryReader.getPredecessors(element2).contains(class1))) {
                return 0;
            }
            if (element1Succeeds) {
                return -1;
            }
            return 1;
        }
    };

    public FactoryOverrideRegistryReader() {
        super(RegistryFactory.getRegistry(), EcorePlugin.INSTANCE.getSymbolicName(), "factory_override");
    }

    @Override
    protected IConfigurationElement[] getFilteredConfigurationElements(IConfigurationElement[] elements) {
        ArrayList<IConfigurationElement> result = new ArrayList<IConfigurationElement>();
        HashMap<String, ArrayList<IConfigurationElement>> uriToElements = new HashMap<String, ArrayList<IConfigurationElement>>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(TAG_FACTORY)) {
                String packageURI = element.getAttribute(ATT_URI);
                if (packageURI == null || element.getAttribute(ATT_CLASS) == null) {
                    result.add(element);
                } else {
                    ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)uriToElements.get(packageURI);
                    if (list == null) {
                        list = new ArrayList<IConfigurationElement>();
                        uriToElements.put(packageURI, list);
                    }
                    list.add(element);
                }
            }
            ++n2;
        }
        for (Map.Entry entry : uriToElements.entrySet()) {
            List list = (List)entry.getValue();
            Collections.sort(list, CONFIGURATION_ELEMENT_COMPARATOR);
            IConfigurationElement firstElement = (IConfigurationElement)list.get(0);
            int i = 1;
            int size = list.size();
            while (i < size) {
                IConfigurationElement element = (IConfigurationElement)list.get(i);
                if (CONFIGURATION_ELEMENT_COMPARATOR.compare(firstElement, element) != 0) break;
                EcorePlugin.INSTANCE.log("Both '" + firstElement.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a factory override for '" + (String)entry.getKey() + "'");
                ++i;
            }
            result.add(firstElement);
        }
        return result.toArray(new IConfigurationElement[result.size()]);
    }

    @Override
    protected boolean readElement(IConfigurationElement element, boolean add) {
        if (element.getName().equals(TAG_FACTORY)) {
            String packageURI = element.getAttribute(ATT_URI);
            if (packageURI == null) {
                this.logMissingAttribute(element, ATT_URI);
            } else if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
            } else {
                if (add) {
                    Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                    if (ePackageDescriptor instanceof EPackage.Descriptor) {
                        EPackage.Registry.INSTANCE.put(packageURI, new RegistryReader.EFactoryDescriptor(element, ATT_CLASS, (EPackage.Descriptor)ePackageDescriptor));
                        if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                            RegistryReader.EFactoryDescriptor descriptor = (RegistryReader.EFactoryDescriptor)ePackageDescriptor;
                            EcorePlugin.INSTANCE.log("Both '" + descriptor.element.getContributor().getName() + "' and '" + element.getContributor().getName() + "' register a factory override for '" + packageURI + "'");
                        }
                    }
                    return true;
                }
                Object ePackageDescriptor = EPackage.Registry.INSTANCE.get(packageURI);
                if (ePackageDescriptor instanceof RegistryReader.EFactoryDescriptor) {
                    EPackage.Registry.INSTANCE.put(packageURI, ((RegistryReader.EFactoryDescriptor)ePackageDescriptor).getOverridenDescriptor());
                }
                return true;
            }
        }
        return false;
    }

    private static Set<String> getPredecessors(IConfigurationElement element) {
        String value = element.getAttribute(ATT_PREDECESSOR);
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> predecessors = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        while (tokenizer.hasMoreTokens()) {
            String predecessor = tokenizer.nextToken().trim();
            if (predecessor.length() == 0) continue;
            predecessors.add(predecessor);
        }
        return predecessors;
    }
}

