/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.OSGiValidationOperation;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.ui.launcher.BundlesTab;

public class OSGiBundleBlock
extends AbstractPluginBlock {
    private ILaunchConfiguration fLaunchConfiguration;

    public OSGiBundleBlock(BundlesTab tab) {
        super(tab);
    }

    @Override
    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] selected = this.fPluginTreeViewer.getCheckedElements();
        AbstractPluginBlock.PluginModelNameBuffer wBuffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        AbstractPluginBlock.PluginModelNameBuffer tBuffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedElement = objectArray[n2];
            if (selectedElement instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)selectedElement;
                if (model.getUnderlyingResource() == null) {
                    tBuffer.add(model);
                } else {
                    wBuffer.add(model);
                }
            }
            ++n2;
        }
        config.setAttribute("workspace_bundles", wBuffer.toString());
        config.setAttribute("target_bundles", tBuffer.toString());
        AbstractPluginBlock.PluginModelNameBuffer buffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        if (this.fAddWorkspaceButton.getSelection()) {
            IPluginModelBase[] workspaceModels = this.getWorkspaceModels();
            int i = 0;
            while (i < workspaceModels.length) {
                if (!this.fPluginTreeViewer.getChecked(workspaceModels[i])) {
                    buffer.add(workspaceModels[i]);
                }
                ++i;
            }
        }
        config.setAttribute("deselected_workspace_plugins", buffer.toString());
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        super.initializeFrom(configuration, true);
        this.initWorkspacePluginsState(configuration);
        this.initExternalPluginsState(configuration);
        this.updateCounter();
        this.fLaunchConfiguration = configuration;
        this.handleFilterButton();
    }

    private void initExternalPluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getTargetBundleMap((ILaunchConfiguration)configuration, (Set)Collections.EMPTY_SET, (String)"target_bundles");
        this.fPluginTreeViewer.setSubtreeChecked(this.fExternalPlugins, false);
        for (Map.Entry entry : map.entrySet()) {
            IPluginModelBase model = (IPluginModelBase)entry.getKey();
            if (!this.fPluginTreeViewer.setChecked(model, true)) continue;
            this.setText(model, ((String)entry.getValue()).toString());
        }
        this.fNumExternalChecked = map.size();
        this.resetGroup(this.fExternalPlugins);
        this.fPluginTreeViewer.setChecked(this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed(this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.getExternalModels().length);
    }

    private void initWorkspacePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map map = BundleLauncherHelper.getWorkspaceBundleMap((ILaunchConfiguration)configuration);
        this.fPluginTreeViewer.setSubtreeChecked(this.fWorkspacePlugins, false);
        for (Map.Entry entry : map.entrySet()) {
            IPluginModelBase model = (IPluginModelBase)entry.getKey();
            if (!this.fPluginTreeViewer.setChecked(model, true)) continue;
            this.setText(model, ((String)entry.getValue()).toString());
        }
        this.fNumWorkspaceChecked = map.size();
        this.resetGroup(this.fWorkspacePlugins);
        this.fPluginTreeViewer.setChecked(this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed(this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.getWorkspaceModels().length);
    }

    @Override
    protected LaunchValidationOperation createValidationOperation() {
        return new OSGiValidationOperation(this.fLaunchConfiguration);
    }
}

